/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.internal.artifact;

import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.publish.maven.MavenArtifact;
import org.gradle.api.publish.maven.MavenArtifactSet;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.typeconversion.NotationParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMavenArtifactSet
extends DefaultDomainObjectSet<MavenArtifact>
implements MavenArtifactSet {
    private final String publicationName;
    private final TaskDependencyInternal builtBy = new ArtifactsTaskDependency();
    private final FileCollection files;
    private final NotationParser<Object, MavenArtifact> mavenArtifactParser;

    public DefaultMavenArtifactSet(String publicationName, NotationParser<Object, MavenArtifact> mavenArtifactParser, FileCollectionFactory fileCollectionFactory) {
        super(MavenArtifact.class);
        this.publicationName = publicationName;
        this.mavenArtifactParser = mavenArtifactParser;
        this.files = fileCollectionFactory.create((TaskDependency)this.builtBy, (MinimalFileSet)new ArtifactsFileCollection());
    }

    @Override
    public MavenArtifact artifact(Object source) {
        MavenArtifact artifact = (MavenArtifact)this.mavenArtifactParser.parseNotation(source);
        this.add(artifact);
        return artifact;
    }

    @Override
    public MavenArtifact artifact(Object source, Action<? super MavenArtifact> config) {
        MavenArtifact artifact = this.artifact(source);
        config.execute((Object)artifact);
        return artifact;
    }

    public FileCollection getFiles() {
        return this.files;
    }

    private class ArtifactsTaskDependency
    extends AbstractTaskDependency {
        private ArtifactsTaskDependency() {
        }

        public void visitDependencies(TaskDependencyResolveContext context) {
            Iterator i$ = DefaultMavenArtifactSet.this.iterator();
            while (i$.hasNext()) {
                MavenArtifact mavenArtifact = (MavenArtifact)i$.next();
                context.add((Object)mavenArtifact);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ArtifactsFileCollection
    implements MinimalFileSet {
        private ArtifactsFileCollection() {
        }

        public String getDisplayName() {
            return String.format("artifacts for Maven publication '%s'", DefaultMavenArtifactSet.this.publicationName);
        }

        public Set<File> getFiles() {
            LinkedHashSet<File> files = new LinkedHashSet<File>();
            Iterator i$ = DefaultMavenArtifactSet.this.iterator();
            while (i$.hasNext()) {
                MavenArtifact artifact = (MavenArtifact)i$.next();
                files.add(artifact.getFile());
            }
            return files;
        }
    }
}

