/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.SaveActionBase;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapFrameListener;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.io.session.SessionLayerExporter;
import org.openstreetmap.josm.io.session.SessionWriter;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.MultiMap;
import org.openstreetmap.josm.tools.UserCancelException;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.WindowGeometry;

public class SessionSaveAsAction
extends DiskAccessAction
implements MapFrameListener {
    private transient List<Layer> layers;
    private transient Map<Layer, SessionLayerExporter> exporters;
    private transient MultiMap<Layer, Layer> dependencies;

    public SessionSaveAsAction() {
        this(true, true);
    }

    protected SessionSaveAsAction(boolean bl, boolean bl2) {
        super(I18n.tr("Save Session As...", new Object[0]), "session", I18n.tr("Save the current session to a new file.", new Object[0]), null, bl, "save_as-session", bl2);
        this.putValue("help", HelpUtil.ht("/Action/SessionSaveAs"));
        Main.addMapFrameListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block2: {
            try {
                this.saveSession();
            }
            catch (UserCancelException userCancelException) {
                if (!Main.isTraceEnabled()) break block2;
                Main.trace(userCancelException.getMessage());
            }
        }
    }

    public void saveSession() throws UserCancelException {
        Layer layer2;
        Object object;
        if (!this.isEnabled()) {
            return;
        }
        SessionSaveAsDialog sessionSaveAsDialog = new SessionSaveAsDialog();
        sessionSaveAsDialog.showDialog();
        if (sessionSaveAsDialog.getValue() != 1) {
            throw new UserCancelException();
        }
        boolean bl = false;
        for (Layer object22 : this.layers) {
            object = this.exporters.get(object22);
            if (object == null || !object.requiresZip()) continue;
            bl = true;
            break;
        }
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("joz", "joz", I18n.tr("Session file (archive) (*.joz)", new Object[0]));
        ExtensionFileFilter extensionFileFilter2 = new ExtensionFileFilter("jos", "jos", I18n.tr("Session file (*.jos)", new Object[0]));
        object = bl ? SessionSaveAsAction.createAndOpenFileChooser(false, false, I18n.tr("Save session", new Object[0]), extensionFileFilter, 0, "lastDirectory") : SessionSaveAsAction.createAndOpenFileChooser(false, false, I18n.tr("Save session", new Object[0]), Arrays.asList(extensionFileFilter2, extensionFileFilter), extensionFileFilter2, 0, "lastDirectory");
        if (object == null) {
            throw new UserCancelException();
        }
        File file = ((AbstractFileChooser)object).getSelectedFile();
        String string = file.getName();
        FileFilter fileFilter = ((AbstractFileChooser)object).getFileFilter();
        boolean bl2 = bl ? true : (((Object)extensionFileFilter).equals(fileFilter) ? true : (((Object)extensionFileFilter2).equals(fileFilter) ? false : Utils.hasExtension(string, "joz")));
        if (string.indexOf(46) == -1 && !SaveActionBase.confirmOverwrite(file = new File(file.getPath() + (bl2 ? ".joz" : ".jos")))) {
            throw new UserCancelException();
        }
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        for (Layer layer2 : this.layers) {
            if (this.exporters.get(layer2) == null || !this.exporters.get(layer2).shallExport()) continue;
            arrayList.add(layer2);
        }
        int n = -1;
        layer2 = Main.getLayerManager().getActiveLayer();
        if (layer2 != null) {
            n = arrayList.indexOf(layer2);
        }
        SessionWriter sessionWriter = new SessionWriter(arrayList, n, this.exporters, this.dependencies, bl2);
        try {
            sessionWriter.write(file);
            SaveActionBase.addToFileOpenHistory(file);
        }
        catch (IOException iOException) {
            Main.error(iOException);
            HelpAwareOptionPane.showMessageDialogInEDT(Main.parent, I18n.tr("<html>Could not save session file ''{0}''.<br>Error is:<br>{1}</html>", file.getName(), iOException.getMessage()), I18n.tr("IO Error", new Object[0]), 0, null);
        }
    }

    @Override
    protected void updateEnabledState() {
        this.setEnabled(Main.isDisplayingMapView());
    }

    @Override
    public void mapFrameInitialized(MapFrame mapFrame, MapFrame mapFrame2) {
        this.updateEnabledState();
    }

    public class SessionSaveAsDialog
    extends ExtendedDialog {
        public SessionSaveAsDialog() {
            super(Main.parent, I18n.tr("Save Session", new Object[0]), new String[]{I18n.tr("Save As", new Object[0]), I18n.tr("Cancel", new Object[0])});
            this.initialize();
            this.setButtonIcons(new String[]{"save_as", "cancel"});
            this.setDefaultButton(1);
            this.setRememberWindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(Main.parent, new Dimension(350, 450)));
            this.setContent(this.build(), false);
        }

        public final void initialize() {
            SessionSaveAsAction.this.layers = new ArrayList<Layer>(Main.getLayerManager().getLayers());
            SessionSaveAsAction.this.exporters = new HashMap();
            SessionSaveAsAction.this.dependencies = new MultiMap();
            HashSet<Object> hashSet = new HashSet<Object>();
            for (Object object : SessionSaveAsAction.this.layers) {
                Object object2 = SessionWriter.getSessionLayerExporter((Layer)object);
                if (object2 != null) {
                    SessionSaveAsAction.this.exporters.put(object, object2);
                    Collection<Layer> collection = object2.getDependencies();
                    if (collection != null) {
                        SessionSaveAsAction.this.dependencies.putAll(object, collection);
                        continue;
                    }
                    SessionSaveAsAction.this.dependencies.putVoid(object);
                    continue;
                }
                hashSet.add(object);
                SessionSaveAsAction.this.exporters.put(object, null);
            }
            int n = 0;
            block1: while (n != hashSet.size()) {
                n = hashSet.size();
                for (Object object2 : SessionSaveAsAction.this.layers) {
                    if (hashSet.contains(object2)) continue;
                    for (Layer layer : SessionSaveAsAction.this.dependencies.get(object2)) {
                        if (!hashSet.contains(layer)) continue;
                        hashSet.add(object2);
                        SessionSaveAsAction.this.exporters.put(object2, null);
                        break block1;
                    }
                }
            }
        }

        protected final Component build() {
            JComponent jComponent;
            Object object2;
            JPanel jPanel = new JPanel(new GridBagLayout());
            for (Object object2 : SessionSaveAsAction.this.layers) {
                Component component;
                jComponent = new JPanel(new GridBagLayout());
                jComponent.setBorder(BorderFactory.createEtchedBorder(0));
                SessionLayerExporter sessionLayerExporter = (SessionLayerExporter)SessionSaveAsAction.this.exporters.get(object2);
                if (sessionLayerExporter == null) {
                    if (!SessionSaveAsAction.this.exporters.containsKey(object2)) {
                        throw new AssertionError();
                    }
                    component = this.getDisabledExportPanel((Layer)object2);
                } else {
                    component = sessionLayerExporter.getExportPanel();
                }
                jComponent.add(component, GBC.std().fill(2));
                jPanel.add((Component)jComponent, GBC.eol().fill(2).insets(2, 2, 4, 2));
            }
            jPanel.add(GBC.glue(0, 1), GBC.eol().fill(3));
            JScrollPane jScrollPane = new JScrollPane(jPanel);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder());
            object2 = new JPanel(new GridBagLayout());
            ((Container)object2).add((Component)jScrollPane, GBC.eol().fill());
            jComponent = new JTabbedPane();
            ((JTabbedPane)jComponent).addTab(I18n.tr("Layers", new Object[0]), (Component)object2);
            return jComponent;
        }

        protected final Component getDisabledExportPanel(Layer layer) {
            JPanel jPanel = new JPanel(new GridBagLayout());
            JCheckBox jCheckBox = new JCheckBox();
            jCheckBox.setEnabled(false);
            JLabel jLabel = new JLabel(layer.getName(), layer.getIcon(), 2);
            jLabel.setToolTipText(I18n.tr("No exporter for this layer", new Object[0]));
            jLabel.setLabelFor(jCheckBox);
            jLabel.setEnabled(false);
            jPanel.add((Component)jCheckBox, GBC.std());
            jPanel.add((Component)jLabel, GBC.std());
            jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
            return jPanel;
        }
    }
}

