/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug;

import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.PolyglotEngine;

public final class ExecutionEvent {
    private final Object[] debugger;
    private final PolyglotEngine engine;
    private final int currentDepth;
    private final Source source;

    ExecutionEvent(PolyglotEngine engine, int currentDepth, Object[] debugger, Source source) {
        this.debugger = debugger;
        this.engine = engine;
        this.currentDepth = currentDepth;
        this.source = source;
    }

    public Debugger getDebugger() {
        if (this.debugger[0] instanceof Debugger) {
            return (Debugger)this.debugger[0];
        }
        try {
            Debugger dbg = Debugger.find(this.engine, true);
            dbg.executionStarted(this.currentDepth, this.source);
            this.debugger[0] = dbg;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        return (Debugger)this.debugger[0];
    }

    public void prepareContinue() {
        this.getDebugger().prepareContinue(-1);
    }

    public void prepareStepInto() {
        this.getDebugger().prepareStepInto(1);
    }
}

