/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.gui;

import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.gui.LanguageComparator;

public class LanguageComboBox
extends JComboBox<Language> {
    private final List<Language> languages = new ArrayList<Language>();
    private final LanguageComparator langComparator;

    public LanguageComboBox(ResourceBundle messages, String extLangSuffix) {
        this.langComparator = new LanguageComparator(messages, extLangSuffix);
        this.populateLanguageBox();
    }

    final void populateLanguageBox(List<Language> externalLanguages) {
        this.removeAllItems();
        this.initAllLanguages(externalLanguages);
    }

    final void populateLanguageBox() {
        this.populateLanguageBox(Collections.emptyList());
    }

    void selectLanguage(Language language) {
        for (Language lang : this.languages) {
            if (!lang.toString().equals(language.toString())) continue;
            this.setSelectedItem(lang);
        }
    }

    private void initAllLanguages(List<Language> externalLanguages) {
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
        this.languages.clear();
        for (Language language : Languages.get()) {
            if (language.isHiddenFromGui()) continue;
            this.languages.add(language);
        }
        for (Language externalLanguage : externalLanguages) {
            this.addItem(externalLanguage);
        }
        Collections.sort(this.languages, this.langComparator);
        for (Language language : this.languages) {
            this.addItem(language);
        }
    }
}

