/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import org.jaxen.JaxenException;
import org.jaxen.expr.BinaryExpr;
import org.jaxen.expr.DefaultAbsoluteLocationPath;
import org.jaxen.expr.DefaultAllNodeStep;
import org.jaxen.expr.DefaultAndExpr;
import org.jaxen.expr.DefaultCommentNodeStep;
import org.jaxen.expr.DefaultDivExpr;
import org.jaxen.expr.DefaultEqualsExpr;
import org.jaxen.expr.DefaultFilterExpr;
import org.jaxen.expr.DefaultFunctionCallExpr;
import org.jaxen.expr.DefaultGreaterThanEqualExpr;
import org.jaxen.expr.DefaultGreaterThanExpr;
import org.jaxen.expr.DefaultLessThanEqualExpr;
import org.jaxen.expr.DefaultLessThanExpr;
import org.jaxen.expr.DefaultLiteralExpr;
import org.jaxen.expr.DefaultMinusExpr;
import org.jaxen.expr.DefaultModExpr;
import org.jaxen.expr.DefaultMultiplyExpr;
import org.jaxen.expr.DefaultNameStep;
import org.jaxen.expr.DefaultNotEqualsExpr;
import org.jaxen.expr.DefaultNumberExpr;
import org.jaxen.expr.DefaultOrExpr;
import org.jaxen.expr.DefaultPathExpr;
import org.jaxen.expr.DefaultPlusExpr;
import org.jaxen.expr.DefaultPredicate;
import org.jaxen.expr.DefaultProcessingInstructionNodeStep;
import org.jaxen.expr.DefaultRelativeLocationPath;
import org.jaxen.expr.DefaultTextNodeStep;
import org.jaxen.expr.DefaultUnaryExpr;
import org.jaxen.expr.DefaultUnionExpr;
import org.jaxen.expr.DefaultVariableReferenceExpr;
import org.jaxen.expr.DefaultXPath;
import org.jaxen.expr.Expr;
import org.jaxen.expr.FilterExpr;
import org.jaxen.expr.FunctionCallExpr;
import org.jaxen.expr.LiteralExpr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.NumberExpr;
import org.jaxen.expr.PathExpr;
import org.jaxen.expr.Predicate;
import org.jaxen.expr.Step;
import org.jaxen.expr.UnionExpr;
import org.jaxen.expr.VariableReferenceExpr;
import org.jaxen.expr.XPath;
import org.jaxen.expr.XPathFactory;
import org.jaxen.expr.iter.IterableAncestorAxis;
import org.jaxen.expr.iter.IterableAncestorOrSelfAxis;
import org.jaxen.expr.iter.IterableAttributeAxis;
import org.jaxen.expr.iter.IterableAxis;
import org.jaxen.expr.iter.IterableChildAxis;
import org.jaxen.expr.iter.IterableDescendantAxis;
import org.jaxen.expr.iter.IterableDescendantOrSelfAxis;
import org.jaxen.expr.iter.IterableFollowingAxis;
import org.jaxen.expr.iter.IterableFollowingSiblingAxis;
import org.jaxen.expr.iter.IterableNamespaceAxis;
import org.jaxen.expr.iter.IterableParentAxis;
import org.jaxen.expr.iter.IterablePrecedingAxis;
import org.jaxen.expr.iter.IterablePrecedingSiblingAxis;
import org.jaxen.expr.iter.IterableSelfAxis;

public class DefaultXPathFactory
implements XPathFactory {
    public LocationPath createAbsoluteLocationPath() throws JaxenException {
        return new DefaultAbsoluteLocationPath();
    }

    public BinaryExpr createAdditiveExpr(Expr lhs, Expr rhs, int additiveOperator) throws JaxenException {
        switch (additiveOperator) {
            case 7: {
                return new DefaultPlusExpr(lhs, rhs);
            }
            case 8: {
                return new DefaultMinusExpr(lhs, rhs);
            }
        }
        throw new JaxenException("Unhandled operator in createAdditiveExpr(): " + additiveOperator);
    }

    public Step createAllNodeStep(int axis) throws JaxenException {
        IterableAxis iter = this.getIterableAxis(axis);
        return new DefaultAllNodeStep(iter);
    }

    public BinaryExpr createAndExpr(Expr lhs, Expr rhs) throws JaxenException {
        return new DefaultAndExpr(lhs, rhs);
    }

    public Step createCommentNodeStep(int axis) throws JaxenException {
        IterableAxis iter = this.getIterableAxis(axis);
        return new DefaultCommentNodeStep(iter);
    }

    public BinaryExpr createEqualityExpr(Expr lhs, Expr rhs, int equalityOperator) throws JaxenException {
        switch (equalityOperator) {
            case 1: {
                return new DefaultEqualsExpr(lhs, rhs);
            }
            case 2: {
                return new DefaultNotEqualsExpr(lhs, rhs);
            }
        }
        throw new JaxenException("Unhandled operator in createEqualityExpr(): " + equalityOperator);
    }

    public FilterExpr createFilterExpr(Expr expr) throws JaxenException {
        return new DefaultFilterExpr(expr);
    }

    public FunctionCallExpr createFunctionCallExpr(String prefix, String functionName) throws JaxenException {
        return new DefaultFunctionCallExpr(prefix, functionName);
    }

    public LiteralExpr createLiteralExpr(String literal) throws JaxenException {
        return new DefaultLiteralExpr(literal);
    }

    public BinaryExpr createMultiplicativeExpr(Expr lhs, Expr rhs, int multiplicativeOperator) throws JaxenException {
        switch (multiplicativeOperator) {
            case 9: {
                return new DefaultMultiplyExpr(lhs, rhs);
            }
            case 11: {
                return new DefaultDivExpr(lhs, rhs);
            }
            case 10: {
                return new DefaultModExpr(lhs, rhs);
            }
        }
        throw new JaxenException("Unhandled operator in createMultiplicativeExpr(): " + multiplicativeOperator);
    }

    public Step createNameStep(int axis, String prefix, String localName) throws JaxenException {
        IterableAxis iter = this.getIterableAxis(axis);
        return new DefaultNameStep(iter, prefix, localName);
    }

    public NumberExpr createNumberExpr(double number) throws JaxenException {
        return new DefaultNumberExpr(new Double(number));
    }

    public NumberExpr createNumberExpr(int number) throws JaxenException {
        return new DefaultNumberExpr(new Double(number));
    }

    public BinaryExpr createOrExpr(Expr lhs, Expr rhs) throws JaxenException {
        return new DefaultOrExpr(lhs, rhs);
    }

    public PathExpr createPathExpr(FilterExpr filterExpr, LocationPath locationPath) throws JaxenException {
        return new DefaultPathExpr(filterExpr, locationPath);
    }

    public Predicate createPredicate(Expr predicateExpr) throws JaxenException {
        return new DefaultPredicate(predicateExpr);
    }

    public Step createProcessingInstructionNodeStep(int axis, String piName) throws JaxenException {
        IterableAxis iter = this.getIterableAxis(axis);
        return new DefaultProcessingInstructionNodeStep(iter, piName);
    }

    public BinaryExpr createRelationalExpr(Expr lhs, Expr rhs, int relationalOperator) throws JaxenException {
        switch (relationalOperator) {
            case 3: {
                return new DefaultLessThanExpr(lhs, rhs);
            }
            case 5: {
                return new DefaultGreaterThanExpr(lhs, rhs);
            }
            case 4: {
                return new DefaultLessThanEqualExpr(lhs, rhs);
            }
            case 6: {
                return new DefaultGreaterThanEqualExpr(lhs, rhs);
            }
        }
        throw new JaxenException("Unhandled operator in createRelationalExpr(): " + relationalOperator);
    }

    public LocationPath createRelativeLocationPath() throws JaxenException {
        return new DefaultRelativeLocationPath();
    }

    public Step createTextNodeStep(int axis) throws JaxenException {
        IterableAxis iter = this.getIterableAxis(axis);
        return new DefaultTextNodeStep(iter);
    }

    public Expr createUnaryExpr(Expr expr, int unaryOperator) throws JaxenException {
        switch (unaryOperator) {
            case 12: {
                return new DefaultUnaryExpr(expr);
            }
        }
        return expr;
    }

    public UnionExpr createUnionExpr(Expr lhs, Expr rhs) throws JaxenException {
        return new DefaultUnionExpr(lhs, rhs);
    }

    public VariableReferenceExpr createVariableReferenceExpr(String prefix, String variable) throws JaxenException {
        return new DefaultVariableReferenceExpr(prefix, variable);
    }

    public XPath createXPath(Expr rootExpr) throws JaxenException {
        return new DefaultXPath(rootExpr);
    }

    protected IterableAxis getIterableAxis(int axis) {
        IterableAxis iter = null;
        switch (axis) {
            case 1: {
                iter = new IterableChildAxis(axis);
                break;
            }
            case 2: {
                iter = new IterableDescendantAxis(axis);
                break;
            }
            case 3: {
                iter = new IterableParentAxis(axis);
                break;
            }
            case 5: {
                iter = new IterableFollowingSiblingAxis(axis);
                break;
            }
            case 6: {
                iter = new IterablePrecedingSiblingAxis(axis);
                break;
            }
            case 7: {
                iter = new IterableFollowingAxis(axis);
                break;
            }
            case 8: {
                iter = new IterablePrecedingAxis(axis);
                break;
            }
            case 9: {
                iter = new IterableAttributeAxis(axis);
                break;
            }
            case 10: {
                iter = new IterableNamespaceAxis(axis);
                break;
            }
            case 11: {
                iter = new IterableSelfAxis(axis);
                break;
            }
            case 12: {
                iter = new IterableDescendantOrSelfAxis(axis);
                break;
            }
            case 13: {
                iter = new IterableAncestorOrSelfAxis(axis);
                break;
            }
            case 4: {
                iter = new IterableAncestorAxis(axis);
                break;
            }
        }
        return iter;
    }
}

