/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import org.parosproxy.paros.core.scanner.MultipartParam;
import org.parosproxy.paros.network.HttpMessage;

public class MultipartFormParser {
    public static final String WWW_MULTIPART_FORM_DATA = "multipart/form-data";
    public static final String DEFAULT_ENCODING = "ISO-8859-1";
    private String boundary = null;
    private String encoding = "ISO-8859-1";
    private BufferedReader br = null;

    private MultipartFormParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MultipartFormParser(HttpMessage httpMessage) throws IOException {
        String string;
        String string2 = httpMessage.getRequestHeader().getHeader("Content-Type");
        if (string2 == null || !string2.startsWith(WWW_MULTIPART_FORM_DATA)) throw new IOException("The request is not a multipart/form-data content");
        this.boundary = this.extractBoundary(string2);
        if (this.boundary == null) throw new IOException("No boundary defined in the Content-type header");
        this.br = new BufferedReader(new StringReader(httpMessage.getRequestBody().toString()));
        do {
            if ((string = this.br.readLine()) != null) continue;
            throw new IOException("Corrupt form data: premature ending");
        } while (!string.startsWith(this.boundary));
    }

    public String getBoundary() {
        return this.boundary;
    }

    public MultipartParam getNextParam() throws IOException {
        boolean bl;
        CharSequence charSequence;
        CharSequence charSequence2 = this.br.readLine();
        if (charSequence2 == null) {
            return null;
        }
        if (charSequence2.length() == 0) {
            return null;
        }
        MultipartParam multipartParam = new MultipartParam();
        while (charSequence2 != null && charSequence2.length() > 0) {
            charSequence = null;
            bl = true;
            while (bl) {
                charSequence = this.br.readLine();
                if (charSequence != null && (((String)charSequence).startsWith(" ") || ((String)charSequence).startsWith("\t"))) {
                    charSequence2 = charSequence2 + (String)charSequence;
                    continue;
                }
                bl = false;
            }
            multipartParam.addHeader((String)charSequence2);
            charSequence2 = charSequence;
        }
        if (charSequence2 == null) {
            return null;
        }
        charSequence2 = this.br.readLine();
        charSequence = new StringBuilder();
        bl = false;
        while (!charSequence2.startsWith(this.boundary)) {
            if (bl) {
                ((StringBuilder)charSequence).append("\r\n");
            } else {
                bl = true;
            }
            ((StringBuilder)charSequence).append((String)charSequence2);
            charSequence2 = this.br.readLine();
        }
        multipartParam.setContent(((StringBuilder)charSequence).toString());
        return multipartParam;
    }

    private String extractBoundary(String string) {
        int n = string.lastIndexOf("boundary=");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(n + 9);
        if (string2.charAt(0) == '\"') {
            n = string2.lastIndexOf(34);
            string2 = string2.substring(1, n);
        }
        string2 = "--" + string2;
        return string2;
    }
}

