/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.apache.log4j.Logger;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.option.OptionsParamView;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.TabbedPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ComponentMaximiser;
import org.zaproxy.zap.view.ComponentMaximiserMouseListener;
import org.zaproxy.zap.view.TabbedPanel2;

public class WorkbenchPanel
extends JPanel {
    private static final long serialVersionUID = -4610792807151921550L;
    private static final Logger logger = Logger.getLogger(WorkbenchPanel.class);
    private static final String PREF_DIVIDER_LOCATION = "divider.location";
    private static final String DIVIDER_VERTICAL = "vertical";
    private static final String DIVIDER_HORIZONTAL = "horizontal";
    private final Preferences preferences;
    private final String prefnzPrefix = this.getClass().getSimpleName() + ".";
    private final AbstractPanel requestPanel;
    private final AbstractPanel responsePanel;
    private final TabbedPanel2 responseTabbedPanel;
    private final ComponentMaximiser componentMaximiser;
    private Layout layout;
    private ResponsePanelPosition responsePanelPosition;
    private TabbedPanel2 tabbedStatus;
    private JPanel paneStatus;
    private TabbedPanel2 tabbedSelect;
    private JPanel paneSelect;
    private TabbedPanel2 tabbedWork;
    private JPanel paneWork;
    private TabbedPanel2 tabbedFull;
    private JPanel fullLayoutPanel;
    private boolean showTabNames;

    @Deprecated
    public WorkbenchPanel(int n) {
        this(Model.getSingleton().getOptionsParam().getViewParam(), View.getSingleton().getRequestPanel(), View.getSingleton().getResponsePanel());
        this.changeDisplayOption(n);
    }

    public WorkbenchPanel(OptionsParamView optionsParamView, AbstractPanel abstractPanel, AbstractPanel abstractPanel2) {
        super(new BorderLayout());
        WorkbenchPanel.validateNotNull(optionsParamView, "viewOptions");
        WorkbenchPanel.validateNotNull(abstractPanel, "requestPanel");
        WorkbenchPanel.validateNotNull(abstractPanel2, "responsePanel");
        this.requestPanel = abstractPanel;
        this.responsePanel = abstractPanel2;
        this.componentMaximiser = new ComponentMaximiser(this);
        this.showTabNames = true;
        ComponentMaximiserMouseListener componentMaximiserMouseListener = new ComponentMaximiserMouseListener(optionsParamView, this.componentMaximiser);
        this.responseTabbedPanel = new TabbedPanel2();
        this.responseTabbedPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.responseTabbedPanel.addMouseListener(componentMaximiserMouseListener);
        this.getTabbedWork().addMouseListener(componentMaximiserMouseListener);
        this.getTabbedStatus().addMouseListener(componentMaximiserMouseListener);
        this.getTabbedSelect().addMouseListener(componentMaximiserMouseListener);
        this.addPanel(abstractPanel, PanelType.WORK);
        this.addPanel(abstractPanel2, PanelType.WORK);
        this.preferences = Preferences.userNodeForPackage(this.getClass());
        this.setResponsePanelPosition(ResponsePanelPosition.TABS_SIDE_BY_SIDE);
        this.setWorkbenchLayout(Layout.EXPAND_STATUS);
    }

    private static void validateNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("Parameter " + string + " must not be null");
        }
    }

    @Deprecated
    public void changeDisplayOption(int n) {
        this.setWorkbenchLayout(Layout.getLayout(n));
    }

    public Layout getWorkbenchLayout() {
        return this.layout;
    }

    void setWorkbenchLayout(Layout layout) {
        WorkbenchPanel.validateNotNull((Object)layout, "layout");
        if (this.layout == layout) {
            return;
        }
        Layout layout2 = this.layout;
        this.layout = layout;
        this.componentMaximiser.unmaximiseComponent();
        this.removeAll();
        switch (layout) {
            case FULL: {
                List<AbstractPanel> list = this.getTabbedStatus().getVisiblePanels();
                list.addAll(this.getTabbedWork().getVisiblePanels());
                list.addAll(this.getTabbedSelect().getVisiblePanels());
                this.getTabbedFull().setVisiblePanels(list);
                this.add(this.getFullLayoutPanel());
                break;
            }
            default: {
                this.add(layout == Layout.EXPAND_STATUS ? this.createStatusPanelsSplit() : this.createSelectPanelsSplit());
                if (layout2 != Layout.FULL) break;
                List<AbstractPanel> list = this.getTabbedFull().getVisiblePanels();
                this.getTabbedStatus().setVisiblePanels(list);
                this.getTabbedWork().setVisiblePanels(list);
                this.getTabbedSelect().setVisiblePanels(list);
                this.setResponsePanelPosition(this.responsePanelPosition);
            }
        }
        this.validate();
        this.repaint();
    }

    private JSplitPane createStatusPanelsSplit() {
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setDividerLocation(this.restoreDividerLocation(DIVIDER_VERTICAL, 300));
        jSplitPane.addPropertyChangeListener("dividerLocation", new DividerResizedListener(DIVIDER_VERTICAL));
        jSplitPane.setDividerSize(3);
        jSplitPane.setOrientation(0);
        jSplitPane.setResizeWeight(0.5);
        switch (this.layout) {
            case EXPAND_SELECT: {
                jSplitPane.setTopComponent(this.getPaneWork());
                break;
            }
            default: {
                jSplitPane.setTopComponent(this.createSelectPanelsSplit());
            }
        }
        jSplitPane.setBottomComponent(this.getPaneStatus());
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return jSplitPane;
    }

    private JSplitPane createSelectPanelsSplit() {
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setLeftComponent(this.getPaneSelect());
        switch (this.layout) {
            case EXPAND_SELECT: {
                jSplitPane.setRightComponent(this.createStatusPanelsSplit());
                break;
            }
            default: {
                jSplitPane.setRightComponent(this.getPaneWork());
            }
        }
        jSplitPane.setDividerLocation(this.restoreDividerLocation(DIVIDER_HORIZONTAL, 300));
        jSplitPane.addPropertyChangeListener("dividerLocation", new DividerResizedListener(DIVIDER_HORIZONTAL));
        jSplitPane.setDividerSize(3);
        jSplitPane.setResizeWeight(0.3);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        return jSplitPane;
    }

    private JPanel getPaneStatus() {
        if (this.paneStatus == null) {
            this.paneStatus = new JPanel();
            this.paneStatus.setLayout(new BorderLayout(0, 0));
            this.paneStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.paneStatus.add(this.getTabbedStatus());
        }
        return this.paneStatus;
    }

    private JPanel getPaneSelect() {
        if (this.paneSelect == null) {
            this.paneSelect = new JPanel();
            this.paneSelect.setLayout(new BorderLayout(0, 0));
            this.paneSelect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.paneSelect.add(this.getTabbedSelect());
        }
        return this.paneSelect;
    }

    private JPanel getPaneWork() {
        if (this.paneWork == null) {
            this.paneWork = new JPanel();
            this.paneWork.setLayout(new BorderLayout(0, 0));
            this.paneWork.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.paneWork.setCursor(new Cursor(0));
            this.paneWork.add(this.getTabbedWork());
        }
        return this.paneWork;
    }

    private JPanel getFullLayoutPanel() {
        if (this.fullLayoutPanel == null) {
            this.fullLayoutPanel = new JPanel();
            this.fullLayoutPanel.setLayout(new BorderLayout(0, 0));
            this.fullLayoutPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.fullLayoutPanel.setCursor(new Cursor(0));
            this.fullLayoutPanel.add(this.getTabbedFull());
        }
        return this.fullLayoutPanel;
    }

    private TabbedPanel2 getTabbedFull() {
        if (this.tabbedFull == null) {
            this.tabbedFull = new TabbedPanel2();
            this.tabbedFull.setName("tabbedFull");
            this.tabbedFull.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedFull;
    }

    @Deprecated
    public void splitPaneWorkWithTabbedPanel(TabbedPanel tabbedPanel, int n) {
    }

    @Deprecated
    public void removeSplitPaneWork() {
    }

    public TabbedPanel2 getTabbedStatus() {
        if (this.tabbedStatus == null) {
            this.tabbedStatus = new TabbedPanel2();
            this.tabbedStatus.setPreferredSize(new Dimension(800, 200));
            this.tabbedStatus.setTabPlacement(1);
            this.tabbedStatus.setName("tabbedStatus");
            this.tabbedStatus.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedStatus;
    }

    @Deprecated
    public TabbedPanel2 getTabbedOldStatus() {
        return new TabbedPanel2();
    }

    public TabbedPanel2 getTabbedWork() {
        if (this.tabbedWork == null) {
            this.tabbedWork = new TabbedPanel2();
            this.tabbedWork.setPreferredSize(new Dimension(600, 400));
            this.tabbedWork.setName("tabbedWork");
            this.tabbedWork.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedWork;
    }

    @Deprecated
    public TabbedPanel2 getTabbedOldWork() {
        return new TabbedPanel2();
    }

    @Deprecated
    public void setTabbedOldWork(TabbedPanel2 tabbedPanel2) {
    }

    @Deprecated
    public void setTabbedOldStatus(TabbedPanel2 tabbedPanel2) {
    }

    @Deprecated
    public void setTabbedOldSelect(TabbedPanel2 tabbedPanel2) {
    }

    public void toggleTabNames(boolean bl) {
        if (this.showTabNames == bl) {
            return;
        }
        this.showTabNames = bl;
        this.responseTabbedPanel.setShowTabNames(bl);
        if (this.layout != Layout.FULL) {
            this.getTabbedStatus().setShowTabNames(bl);
            this.getTabbedSelect().setShowTabNames(bl);
            this.getTabbedWork().setShowTabNames(bl);
        } else {
            this.getTabbedFull().setShowTabNames(bl);
        }
    }

    public TabbedPanel2 getTabbedSelect() {
        if (this.tabbedSelect == null) {
            this.tabbedSelect = new TabbedPanel2();
            this.tabbedSelect.setPreferredSize(new Dimension(200, 400));
            this.tabbedSelect.setName("tabbedSelect");
            this.tabbedSelect.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        }
        return this.tabbedSelect;
    }

    @Deprecated
    public TabbedPanel2 getTabbedOldSelect() {
        return new TabbedPanel2();
    }

    public void addPanels(List<AbstractPanel> list, PanelType panelType) {
        WorkbenchPanel.validateNotNull(list, "panels");
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        WorkbenchPanel.addPanels(this.getTabbedFull(), list);
        switch (panelType) {
            case SELECT: {
                WorkbenchPanel.addPanels(this.getTabbedSelect(), list);
                break;
            }
            case STATUS: {
                WorkbenchPanel.addPanels(this.getTabbedStatus(), list);
                break;
            }
            case WORK: {
                WorkbenchPanel.addPanels(this.getTabbedWork(), list);
                break;
            }
        }
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().setVisiblePanels(this.getTabbedFull().getVisiblePanels());
        }
    }

    private static void addPanels(TabbedPanel2 tabbedPanel2, List<AbstractPanel> list) {
        for (AbstractPanel abstractPanel : list) {
            WorkbenchPanel.addPanel(tabbedPanel2, abstractPanel);
        }
        tabbedPanel2.revalidate();
    }

    private static void addPanel(TabbedPanel2 tabbedPanel2, AbstractPanel abstractPanel) {
        tabbedPanel2.addTab(abstractPanel);
    }

    public void addPanel(AbstractPanel abstractPanel, PanelType panelType) {
        WorkbenchPanel.validateNotNull(abstractPanel, "panel");
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        WorkbenchPanel.addPanel(this.getTabbedFull(), abstractPanel);
        switch (panelType) {
            case SELECT: {
                WorkbenchPanel.addPanel(this.getTabbedSelect(), abstractPanel);
                this.getTabbedSelect().revalidate();
                break;
            }
            case STATUS: {
                WorkbenchPanel.addPanel(this.getTabbedStatus(), abstractPanel);
                this.getTabbedStatus().revalidate();
                break;
            }
            case WORK: {
                WorkbenchPanel.addPanel(this.getTabbedWork(), abstractPanel);
                this.getTabbedWork().revalidate();
                break;
            }
        }
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().setVisiblePanels(this.getTabbedFull().getVisiblePanels());
        }
    }

    public void removePanels(List<AbstractPanel> list, PanelType panelType) {
        WorkbenchPanel.validateNotNull(list, "panels");
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        WorkbenchPanel.removePanels(this.getTabbedFull(), list);
        switch (panelType) {
            case SELECT: {
                WorkbenchPanel.removePanels(this.getTabbedSelect(), list);
                break;
            }
            case STATUS: {
                WorkbenchPanel.removePanels(this.getTabbedStatus(), list);
                break;
            }
            case WORK: {
                WorkbenchPanel.removePanels(this.getTabbedWork(), list);
                break;
            }
        }
    }

    private static void removePanels(TabbedPanel2 tabbedPanel2, List<AbstractPanel> list) {
        for (AbstractPanel abstractPanel : list) {
            WorkbenchPanel.removeTabPanel(tabbedPanel2, abstractPanel);
        }
        tabbedPanel2.revalidate();
    }

    private static void removeTabPanel(TabbedPanel2 tabbedPanel2, AbstractPanel abstractPanel) {
        tabbedPanel2.removeTab(abstractPanel);
    }

    public void removePanel(AbstractPanel abstractPanel, PanelType panelType) {
        WorkbenchPanel.validateNotNull(abstractPanel, "panel");
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        WorkbenchPanel.removeTabPanel(this.getTabbedFull(), abstractPanel);
        this.getTabbedFull().revalidate();
        switch (panelType) {
            case SELECT: {
                WorkbenchPanel.removeTabPanel(this.getTabbedSelect(), abstractPanel);
                this.getTabbedSelect().revalidate();
                break;
            }
            case STATUS: {
                WorkbenchPanel.removeTabPanel(this.getTabbedStatus(), abstractPanel);
                this.getTabbedStatus().revalidate();
                break;
            }
            case WORK: {
                WorkbenchPanel.removeTabPanel(this.getTabbedWork(), abstractPanel);
                this.getTabbedWork().revalidate();
                break;
            }
        }
    }

    public List<AbstractPanel> getPanels(PanelType panelType) {
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        ArrayList<AbstractPanel> arrayList = new ArrayList<AbstractPanel>();
        switch (panelType) {
            case SELECT: {
                arrayList.addAll(this.getTabbedSelect().getPanels());
                break;
            }
            case STATUS: {
                arrayList.addAll(this.getTabbedStatus().getPanels());
                break;
            }
            case WORK: {
                arrayList.addAll(this.getTabbedWork().getPanels());
                break;
            }
        }
        return arrayList;
    }

    public SortedSet<AbstractPanel> getSortedPanels(PanelType panelType) {
        WorkbenchPanel.validateNotNull((Object)panelType, "panelType");
        List<AbstractPanel> list = this.getPanels(panelType);
        TreeSet<AbstractPanel> treeSet = new TreeSet<AbstractPanel>(new Comparator<AbstractPanel>(){

            @Override
            public int compare(AbstractPanel abstractPanel, AbstractPanel abstractPanel2) {
                String string = abstractPanel.getName();
                String string2 = abstractPanel2.getName();
                if (string == null) {
                    if (string2 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (string2 == null) {
                    return 1;
                }
                return string.compareTo(string2);
            }
        });
        treeSet.addAll(list);
        return treeSet;
    }

    public void setPanelsVisible(boolean bl) {
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().setPanelsVisible(bl);
        } else {
            this.getTabbedSelect().setPanelsVisible(bl);
            this.getTabbedWork().setPanelsVisible(bl);
            this.getTabbedStatus().setPanelsVisible(bl);
        }
    }

    public void pinVisiblePanels() {
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().pinVisibleTabs();
        } else {
            this.getTabbedSelect().pinVisibleTabs();
            this.getTabbedWork().pinVisibleTabs();
            this.getTabbedStatus().pinVisibleTabs();
        }
    }

    public void unpinVisiblePanels() {
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().unpinTabs();
        } else {
            this.getTabbedSelect().unpinTabs();
            this.getTabbedWork().unpinTabs();
            this.getTabbedStatus().unpinTabs();
        }
    }

    public void showPanel(AbstractPanel abstractPanel) {
        WorkbenchPanel.validateNotNull(abstractPanel, "panel");
        if (this.layout == Layout.FULL) {
            this.getTabbedFull().setVisible(abstractPanel, true);
        } else {
            this.getTabbedSelect().setVisible(abstractPanel, true);
            this.getTabbedStatus().setVisible(abstractPanel, true);
            this.getTabbedWork().setVisible(abstractPanel, true);
        }
        abstractPanel.setTabFocus();
    }

    void setResponsePanelPosition(ResponsePanelPosition responsePanelPosition) {
        WorkbenchPanel.validateNotNull((Object)responsePanelPosition, "position");
        this.responsePanelPosition = responsePanelPosition;
        if (this.layout == Layout.FULL) {
            return;
        }
        Component component = this.componentMaximiser.getMaximisedComponent();
        if (this.componentMaximiser.isComponentMaximised()) {
            this.componentMaximiser.unmaximiseComponent();
        }
        switch (responsePanelPosition) {
            case PANEL_ABOVE: {
                this.splitResponsePanelWithWorkTabbedPanel(0);
                break;
            }
            case PANELS_SIDE_BY_SIDE: {
                this.splitResponsePanelWithWorkTabbedPanel(1);
                break;
            }
            default: {
                if (component == this.responseTabbedPanel) {
                    component = this.tabbedWork;
                }
                String string = this.showTabNames ? this.responsePanel.getName() : "";
                this.tabbedWork.insertTab(string, DisplayUtils.getScaledIcon(this.responsePanel.getIcon()), this.responsePanel, null, this.tabbedWork.indexOfComponent(this.requestPanel) + 1);
                this.getPaneWork().removeAll();
                this.getPaneWork().add(this.getTabbedWork());
                this.getPaneWork().validate();
            }
        }
        if (component != null) {
            this.componentMaximiser.maximiseComponent(component);
        }
    }

    private void splitResponsePanelWithWorkTabbedPanel(int n) {
        this.responseTabbedPanel.removeAll();
        String string = this.showTabNames ? this.responsePanel.getName() : "";
        this.responseTabbedPanel.addTab(string, DisplayUtils.getScaledIcon(this.responsePanel.getIcon()), this.responsePanel);
        this.getPaneWork().removeAll();
        JSplitPane jSplitPane = new JSplitPane(n);
        jSplitPane.setDividerSize(3);
        jSplitPane.setResizeWeight(0.5);
        jSplitPane.setContinuousLayout(false);
        jSplitPane.setDoubleBuffered(true);
        jSplitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jSplitPane.setRightComponent(this.responseTabbedPanel);
        jSplitPane.setLeftComponent(this.getTabbedWork());
        this.getPaneWork().add(jSplitPane);
        this.getPaneWork().validate();
    }

    private void saveDividerLocation(String string, int n) {
        if (n > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Saving preference " + this.prefnzPrefix + string + "." + PREF_DIVIDER_LOCATION + "=" + n));
            }
            this.preferences.put(this.prefnzPrefix + string + "." + PREF_DIVIDER_LOCATION, Integer.toString(n));
            try {
                this.preferences.flush();
            }
            catch (BackingStoreException backingStoreException) {
                logger.error((Object)"Error while saving the preferences", (Throwable)backingStoreException);
            }
        }
    }

    private int restoreDividerLocation(String string, int n) {
        int n2 = n;
        String string2 = this.preferences.get(this.prefnzPrefix + string + "." + PREF_DIVIDER_LOCATION, null);
        if (string2 != null) {
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string2.trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n3 > 0) {
                n2 = n3;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Restoring preference " + this.prefnzPrefix + string + "." + PREF_DIVIDER_LOCATION + "=" + n3));
                }
            }
        }
        return n2;
    }

    private final class DividerResizedListener
    implements PropertyChangeListener {
        private final String prefix;

        public DividerResizedListener(String string) {
            assert (string != null);
            this.prefix = string;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            JSplitPane jSplitPane = (JSplitPane)propertyChangeEvent.getSource();
            if (jSplitPane != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)(WorkbenchPanel.this.prefnzPrefix + this.prefix + "." + "location" + "=" + jSplitPane.getDividerLocation()));
                }
                WorkbenchPanel.this.saveDividerLocation(this.prefix, jSplitPane.getDividerLocation());
            }
        }
    }

    public static enum PanelType {
        STATUS,
        SELECT,
        WORK;

    }

    public static enum ResponsePanelPosition {
        TABS_SIDE_BY_SIDE,
        PANEL_ABOVE,
        PANELS_SIDE_BY_SIDE;

    }

    public static enum Layout {
        EXPAND_SELECT(0),
        EXPAND_STATUS(1),
        FULL(2);

        private final int id;

        private Layout(int n2) {
            this.id = n2;
        }

        public int getId() {
            return this.id;
        }

        public static Layout getLayout(int n) {
            if (n == EXPAND_SELECT.getId()) {
                return EXPAND_SELECT;
            }
            if (n == EXPAND_STATUS.getId()) {
                return EXPAND_STATUS;
            }
            if (n == FULL.getId()) {
                return FULL;
            }
            return EXPAND_STATUS;
        }
    }
}

