/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.parosproxy.paros.Constant;

public final class TimeStampUtils {
    private static final String DEFAULT_TIME_STAMP_FORMAT = Constant.messages.getString("timestamp.format.default");
    private static final String TIME_STAMP_DELIMITER = Constant.messages.getString("timestamp.format.delimiter");
    private static final String SAFE_TIME_STAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";

    private TimeStampUtils() {
    }

    public static String currentDefaultFormattedTimeStamp() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DEFAULT_TIME_STAMP_FORMAT);
            String string = simpleDateFormat.format(new Date());
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(SAFE_TIME_STAMP_FORMAT);
            String string = simpleDateFormat.format(new Date());
            return string;
        }
    }

    public static String currentFormattedTimeStamp(String string) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            String string2 = simpleDateFormat.format(new Date());
            return string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return TimeStampUtils.currentDefaultFormattedTimeStamp();
        }
        catch (NullPointerException nullPointerException) {
            return TimeStampUtils.currentDefaultFormattedTimeStamp();
        }
    }

    public static String getTimeStampedMessage(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string2.length() + TIME_STAMP_DELIMITER.length() + string.length() + 2);
        stringBuilder.append(TimeStampUtils.currentFormattedTimeStamp(string2));
        stringBuilder.append(' ').append(TIME_STAMP_DELIMITER).append(' ');
        stringBuilder.append(string);
        return stringBuilder.toString();
    }
}

