/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;

public class InteriorPointArea {
    private GeometryFactory factory;
    private Coordinate interiorPoint = null;
    private double maxWidth = 0.0;

    private static double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    public InteriorPointArea(Geometry g) {
        this.factory = g.getFactory();
        this.add(g);
    }

    public Coordinate getInteriorPoint() {
        return this.interiorPoint;
    }

    private void add(Geometry geom) {
        if (geom instanceof Polygon) {
            this.addPolygon(geom);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                this.add(gc.getGeometryN(i));
            }
        }
    }

    public void addPolygon(Geometry geometry) {
        LineString bisector = this.horizontalBisector(geometry);
        Geometry intersections = bisector.intersection(geometry);
        Geometry widestIntersection = this.widestGeometry(intersections);
        double width = widestIntersection.getEnvelopeInternal().getWidth();
        if (this.interiorPoint == null || width > this.maxWidth) {
            this.interiorPoint = this.centre(widestIntersection.getEnvelopeInternal());
            this.maxWidth = width;
        }
    }

    protected Geometry widestGeometry(Geometry geometry) {
        if (!(geometry instanceof GeometryCollection)) {
            return geometry;
        }
        return this.widestGeometry((GeometryCollection)geometry);
    }

    private Geometry widestGeometry(GeometryCollection gc) {
        if (gc.isEmpty()) {
            return gc;
        }
        Geometry widestGeometry = gc.getGeometryN(0);
        for (int i = 1; i < gc.getNumGeometries(); ++i) {
            if (!(gc.getGeometryN(i).getEnvelopeInternal().getWidth() > widestGeometry.getEnvelopeInternal().getWidth())) continue;
            widestGeometry = gc.getGeometryN(i);
        }
        return widestGeometry;
    }

    protected LineString horizontalBisector(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        double avgY = InteriorPointArea.avg(envelope.getMinY(), envelope.getMaxY());
        return this.factory.createLineString(new Coordinate[]{new Coordinate(envelope.getMinX(), avgY), new Coordinate(envelope.getMaxX(), avgY)});
    }

    public Coordinate centre(Envelope envelope) {
        return new Coordinate(InteriorPointArea.avg(envelope.getMinX(), envelope.getMaxX()), InteriorPointArea.avg(envelope.getMinY(), envelope.getMaxY()));
    }
}

