/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import com.spatial4j.core.shape.Shape;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.elasticsearch.common.geo.builders.BaseLineStringBuilder;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class MultiLineStringBuilder
extends ShapeBuilder {
    public static final ShapeBuilder.GeoShapeType TYPE = ShapeBuilder.GeoShapeType.MULTILINESTRING;
    private final ArrayList<BaseLineStringBuilder<?>> lines = new ArrayList();

    public InternalLineStringBuilder linestring() {
        InternalLineStringBuilder line = new InternalLineStringBuilder(this);
        this.lines.add(line);
        return line;
    }

    public MultiLineStringBuilder linestring(BaseLineStringBuilder<?> line) {
        this.lines.add(line);
        return this;
    }

    public Coordinate[][] coordinates() {
        Coordinate[][] result = new Coordinate[this.lines.size()][];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.lines.get(i).coordinates(false);
        }
        return result;
    }

    @Override
    public ShapeBuilder.GeoShapeType type() {
        return TYPE;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", MultiLineStringBuilder.TYPE.shapename);
        builder.field("coordinates");
        builder.startArray();
        for (BaseLineStringBuilder<?> line : this.lines) {
            line.coordinatesToXcontent(builder, false);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    @Override
    public Shape build() {
        MultiLineString geometry;
        if (this.wrapdateline) {
            ArrayList<LineString> parts = new ArrayList<LineString>();
            for (BaseLineStringBuilder<?> line : this.lines) {
                BaseLineStringBuilder.decompose(FACTORY, line.coordinates(false), parts);
            }
            if (parts.size() == 1) {
                geometry = (Geometry)parts.get(0);
            } else {
                LineString[] lineStrings = parts.toArray(new LineString[parts.size()]);
                geometry = FACTORY.createMultiLineString(lineStrings);
            }
        } else {
            LineString[] lineStrings = new LineString[this.lines.size()];
            Iterator<BaseLineStringBuilder<?>> iterator = this.lines.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                lineStrings[i] = FACTORY.createLineString(iterator.next().coordinates(false));
                ++i;
            }
            geometry = FACTORY.createMultiLineString(lineStrings);
        }
        return this.jtsGeometry((Geometry)geometry);
    }

    public static class InternalLineStringBuilder
    extends BaseLineStringBuilder<InternalLineStringBuilder> {
        private final MultiLineStringBuilder collection;

        public InternalLineStringBuilder(MultiLineStringBuilder collection) {
            this.collection = collection;
        }

        public MultiLineStringBuilder end() {
            return this.collection;
        }

        public Coordinate[] coordinates() {
            return super.coordinates(false);
        }

        @Override
        public ShapeBuilder.GeoShapeType type() {
            return null;
        }
    }
}

