/*
 * Decompiled with CFR 0.152.
 */
package org.simpleframework.http.core;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simpleframework.http.core.Sender;
import org.simpleframework.transport.Transport;

class TransportSender
implements Sender {
    private Transport transport;
    private volatile boolean closed;

    public TransportSender(Transport transport) {
        this.transport = transport;
    }

    public void send(byte[] array) throws IOException {
        this.send(array, 0, array.length);
    }

    public void send(byte[] array, int off, int len) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(array, off, len);
        if (len > 0) {
            this.send(buffer);
        }
    }

    public void send(ByteBuffer buffer) throws IOException {
        int size;
        int mark = buffer.position();
        if (mark > (size = buffer.limit())) {
            throw new IOException("Buffer position greater than limit");
        }
        this.send(buffer, 0, size - mark);
    }

    public void send(ByteBuffer buffer, int off, int len) throws IOException {
        int mark = buffer.position();
        int limit = buffer.limit();
        if (limit - mark > len) {
            buffer.limit(mark + len);
        }
        this.transport.write(buffer);
        buffer.limit(limit);
    }

    public void flush() throws IOException {
        this.transport.flush();
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.transport.close();
            this.closed = true;
        }
    }
}

