/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Map;
import javajs.util.Lst;
import javajs.util.Matrix;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.readers.cif.MSRdr;
import org.jmol.api.SymmetryInterface;
import org.jmol.symmetry.Symmetry;
import org.jmol.util.Logger;
import org.jmol.util.SimpleUnitCell;

class Subsystem {
    private MSRdr msRdr;
    private String code;
    private int d;
    private Matrix w;
    private SymmetryInterface symmetry;
    private Matrix[] modMatrices;
    private boolean isFinalized;

    Subsystem(MSRdr msRdr, String code, Matrix w) {
        this.msRdr = msRdr;
        this.code = code;
        this.w = w;
        this.d = w.getArray().length - 3;
    }

    public SymmetryInterface getSymmetry() {
        if (!this.isFinalized) {
            this.setSymmetry(true);
        }
        return this.symmetry;
    }

    public Matrix[] getModMatrices() {
        if (!this.isFinalized) {
            this.setSymmetry(true);
        }
        return this.modMatrices;
    }

    private void setSymmetry(boolean setOperators) {
        Logger.info("[subsystem " + this.code + "]");
        Matrix winv = this.w.inverse();
        Logger.info("w=" + this.w);
        Logger.info("w_inv=" + winv);
        Matrix w33 = this.w.getSubmatrix(0, 0, 3, 3);
        Matrix wd3 = this.w.getSubmatrix(3, 0, this.d, 3);
        Matrix w3d = this.w.getSubmatrix(0, 3, 3, this.d);
        Matrix wdd = this.w.getSubmatrix(3, 3, this.d, this.d);
        Matrix sigma = this.msRdr.getSigma();
        Matrix sigma_nu = wdd.mul(sigma).add(wd3).mul(w3d.mul(sigma).add(w33).inverse());
        Matrix tFactor = wdd.sub(sigma_nu.mul(w3d));
        Logger.info("sigma_nu = " + sigma_nu);
        SymmetryInterface s0 = this.msRdr.cr.asc.getSymmetry();
        T3[] vu43 = s0.getUnitCellVectors();
        P3[] vr43 = SimpleUnitCell.getReciprocal(vu43, null);
        Matrix mard3 = new Matrix(null, 3 + this.d, 3);
        Matrix mar3 = new Matrix(null, 3, 3);
        double[][] mard3a = mard3.getArray();
        double[][] mar3a = mar3.getArray();
        for (int i = 0; i < 3; ++i) {
            mar3a[i] = new double[]{vr43[i + 1].x, vr43[i + 1].y, vr43[i + 1].z};
            mard3a[i] = mar3a[i];
        }
        Matrix sx = sigma.mul(mar3);
        double[][] a = sx.getArray();
        for (int i = 0; i < this.d; ++i) {
            mard3a[i + 3] = a[i];
        }
        a = this.w.mul(mard3).getArray();
        T3[] uc_nu = new T3[4];
        uc_nu[0] = vu43[0];
        for (int i = 0; i < 3; ++i) {
            uc_nu[i + 1] = V3.new3((float)a[i][0], (float)a[i][1], (float)a[i][2]);
        }
        uc_nu = SimpleUnitCell.getReciprocal(uc_nu, null);
        this.symmetry = ((Symmetry)this.msRdr.cr.getInterface("org.jmol.symmetry.Symmetry")).getUnitCell(uc_nu, false, null);
        this.modMatrices = new Matrix[]{sigma_nu, tFactor};
        if (!setOperators) {
            return;
        }
        this.isFinalized = true;
        Logger.info("unit cell parameters: " + this.symmetry.getUnitCellInfo());
        this.symmetry.createSpaceGroup(-1, "[subsystem " + this.code + "]", new Lst());
        int nOps = s0.getSpaceGroupOperationCount();
        for (int iop = 0; iop < nOps; ++iop) {
            Matrix rv = s0.getOperationRsVs(iop);
            Matrix r0 = rv.getRotation();
            Matrix v0 = rv.getTranslation();
            Matrix r = this.w.mul(r0).mul(winv);
            Matrix v = this.w.mul(v0);
            String code = this.code;
            if (this.isMixed(r)) {
                for (Map.Entry<String, Subsystem> e : this.msRdr.htSubsystems.entrySet()) {
                    Matrix rj;
                    Subsystem ss = e.getValue();
                    if (ss == this || this.isMixed(rj = ss.w.mul(r0).mul(winv))) continue;
                    r = rj;
                    v = ss.w.mul(v0);
                    code = ss.code;
                    break;
                }
            }
            String jf = this.symmetry.addOp(code, r, v, sigma_nu);
            Logger.info(this.code + "." + (iop + 1) + (this.code.equals(code) ? "   " : ">" + code + " ") + jf);
        }
    }

    private boolean isMixed(Matrix r) {
        double[][] a = r.getArray();
        int i = 3;
        while (--i >= 0) {
            int j = 3 + this.d;
            while (--j >= 3) {
                if (a[i][j] == 0.0) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "Subsystem " + this.code + "\n" + this.w;
    }
}

