/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rope;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import java.nio.charset.StandardCharsets;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.LazyRope;
import org.jruby.truffle.core.rope.Rope;

public class LazyIntRope
extends LazyRope {
    final int value;

    public LazyIntRope(int value) {
        this(value, (Encoding)USASCIIEncoding.INSTANCE, LazyIntRope.length(value));
    }

    protected LazyIntRope(int value, Encoding encoding, int length) {
        super(encoding, length, length);
        this.value = value;
        assert (Integer.toString(value).length() == length);
    }

    @ExplodeLoop
    private static int length(int value) {
        if (value < 0) {
            if (value <= -1000000000) {
                return 11;
            }
            value = -value;
            value *= 10;
        }
        int n = 1;
        int limit = 10;
        while (n < 10) {
            if (value < limit) {
                return n;
            }
            ++n;
            limit *= 10;
        }
        return 10;
    }

    @Override
    public Rope withEncoding(Encoding newEncoding, CodeRange newCodeRange) {
        if (newCodeRange != this.getCodeRange()) {
            CompilerDirectives.transferToInterpreter();
            throw new UnsupportedOperationException("Cannot fast-path updating encoding with different code range.");
        }
        return new LazyIntRope(this.value, newEncoding, LazyIntRope.length(this.value));
    }

    @Override
    public byte[] fulfill() {
        if (this.bytes == null) {
            this.bytes = Integer.toString(this.value).getBytes(StandardCharsets.US_ASCII);
        }
        return this.bytes;
    }

    public int getValue() {
        return this.value;
    }
}

