/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.configuration;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javafx.scene.image.ImageView;
import javax.inject.Inject;
import org.pdfsam.configuration.StylesConfig;
import org.pdfsam.context.DefaultUserContext;
import org.pdfsam.context.UserContext;
import org.pdfsam.ui.Theme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;

@Configuration
@PropertySource(value={"classpath:pdfsam.properties"})
public class PdfsamConfig {
    private static final Logger LOG = LoggerFactory.getLogger(PdfsamConfig.class);
    @Inject
    private Environment env;

    @Bean
    public ImageView payoff() throws IOException {
        return new ImageView(new ClassPathResource("/images/payoff.png").getURL().toExternalForm());
    }

    @Bean(name={"updatesUrl"})
    public URL updatesUrl() throws MalformedURLException {
        return new URL(String.format("http://www.pdfsam.org/current-version?c=%s", this.env.getProperty("pdfsam.version")));
    }

    @Bean
    public UserContext userContext() {
        return new DefaultUserContext();
    }

    @Bean
    public StylesConfig styles() {
        String themeString = this.userContext().getTheme();
        Theme selected = Theme.ROUNDISH;
        try {
            selected = Theme.valueOf(themeString);
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Unable to find selected theme: {}.", (Object)themeString);
        }
        return new StylesConfig(selected);
    }

    @Bean(name={"errorSound"})
    public String error() throws URISyntaxException {
        return this.getClass().getResource("/sounds/error_sound.wav").toURI().toString();
    }

    @Bean(name={"okSound"})
    public String ok() throws URISyntaxException {
        return this.getClass().getResource("/sounds/ok_sound.wav").toURI().toString();
    }
}

