/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import javax.swing.KeyStroke;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.view.ZapMenuItem;

class KeyboardMapping {
    private ZapMenuItem menuItem;
    private String i18nKey;

    public KeyboardMapping() {
    }

    public KeyboardMapping(String string) {
        this.i18nKey = string;
    }

    public KeyboardMapping(ZapMenuItem zapMenuItem) {
        this.menuItem = zapMenuItem;
    }

    public String getName() {
        if (this.menuItem != null) {
            return this.menuItem.getText();
        }
        return null;
    }

    public String getIdentifier() {
        if (this.menuItem != null) {
            return this.menuItem.getIdenfifier();
        }
        return this.i18nKey;
    }

    public KeyStroke getKeyStroke() {
        if (this.menuItem != null) {
            return this.menuItem.getAccelerator();
        }
        return null;
    }

    public String getKeyStrokeKeyCodeString() {
        if (this.menuItem == null || this.menuItem.getAccelerator() == null) {
            return "";
        }
        return KeyboardMapping.keyString(this.menuItem.getAccelerator().getKeyCode());
    }

    public static String keyString(int n) {
        if (n >= 112 && n <= 123) {
            return "F" + (n - 112 + 1);
        }
        if (n == 38) {
            return Constant.messages.getString("keyboard.key.up");
        }
        if (n == 40) {
            return Constant.messages.getString("keyboard.key.down");
        }
        if (n == 37) {
            return Constant.messages.getString("keyboard.key.left");
        }
        if (n == 39) {
            return Constant.messages.getString("keyboard.key.right");
        }
        return String.valueOf((char)n).toUpperCase();
    }

    public static char keyCode(String string) {
        if (string.length() == 1) {
            return string.charAt(0);
        }
        if (string.startsWith("F")) {
            return (char)(112 + Integer.parseInt(string.substring(1)) - 1);
        }
        if (string.equals(Constant.messages.getString("keyboard.key.up"))) {
            return '&';
        }
        if (string.equals(Constant.messages.getString("keyboard.key.down"))) {
            return '(';
        }
        if (string.equals(Constant.messages.getString("keyboard.key.left"))) {
            return '%';
        }
        if (string.equals(Constant.messages.getString("keyboard.key.right"))) {
            return '\'';
        }
        return '\u0000';
    }

    public String getKeyStrokeModifiersString() {
        if (this.menuItem == null || this.menuItem.getAccelerator() == null) {
            return "";
        }
        return KeyboardMapping.modifiersString(this.menuItem.getAccelerator().getModifiers());
    }

    public static String modifiersString(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x80) > 0) {
            stringBuilder.append(Constant.messages.getString("keyboard.key.control"));
            stringBuilder.append(" ");
        }
        if ((n & 0x200) > 0) {
            stringBuilder.append(Constant.messages.getString("keyboard.key.alt"));
            stringBuilder.append(" ");
        }
        if ((n & 0x40) > 0) {
            stringBuilder.append(Constant.messages.getString("keyboard.key.shift"));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public String getKeyStrokeString() {
        if (this.menuItem == null || this.menuItem.getAccelerator() == null) {
            return "";
        }
        return this.getKeyStrokeModifiersString() + " " + this.getKeyStrokeKeyCodeString();
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        if (this.menuItem != null) {
            this.menuItem.setAccelerator(keyStroke);
        }
    }

    public int hashCode() {
        return 31 * super.hashCode() + (this.menuItem == null ? 0 : this.menuItem.hashCode());
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        KeyboardMapping keyboardMapping = (KeyboardMapping)object;
        return !(this.menuItem == null ? keyboardMapping.menuItem != null : !this.menuItem.equals(keyboardMapping.menuItem));
    }
}

