/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.sourceforge.jnlp.util.lockingfile.LockedFile;
import net.sourceforge.jnlp.util.logging.OutputController;

public class PropertiesFile
extends Properties {
    LockedFile lockedFile;
    String header = "netx file";
    long lastStore;

    public PropertiesFile(File file) {
        this.lockedFile = LockedFile.getInstance(file);
    }

    public PropertiesFile(File file, String header) {
        this.lockedFile = LockedFile.getInstance(file);
        this.header = header;
    }

    @Override
    public String getProperty(String key) {
        if (this.lastStore == 0L) {
            this.load();
        }
        return super.getProperty(key);
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        if (this.lastStore == 0L) {
            this.load();
        }
        return super.getProperty(key, defaultValue);
    }

    @Override
    public Object setProperty(String key, String value) {
        if (this.lastStore == 0L) {
            this.load();
        }
        return super.setProperty(key, value);
    }

    public File getStoreFile() {
        return this.lockedFile.getFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        File file = this.lockedFile.getFile();
        if (!file.exists()) {
            return false;
        }
        long currentStore = file.lastModified();
        long currentTime = System.currentTimeMillis();
        if (this.lastStore == 0L || currentStore != this.lastStore || currentStore == this.lastStore && currentStore / 1000L == currentTime / 1000L) {
            FileInputStream s = null;
            try {
                try {
                    s = new FileInputStream(file);
                    this.load(s);
                }
                finally {
                    if (s != null) {
                        ((InputStream)s).close();
                        this.lastStore = currentStore;
                        return true;
                    }
                }
            }
            catch (IOException ex) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store() {
        File file = this.lockedFile.getFile();
        FileOutputStream s = null;
        try {
            try {
                file.getParentFile().mkdirs();
                s = new FileOutputStream(file);
                this.store(s, this.header);
                s.getChannel().force(true);
                this.lastStore = file.lastModified();
            }
            finally {
                if (s != null) {
                    s.close();
                }
            }
        }
        catch (IOException ex) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
        }
    }

    public void lock() {
        try {
            this.lockedFile.lock();
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    public boolean tryLock() {
        try {
            return this.lockedFile.tryLock();
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            return false;
        }
    }

    public void unlock() {
        try {
            this.lockedFile.unlock();
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
    }

    public boolean isHeldByCurrentThread() {
        return this.lockedFile.isHeldByCurrentThread();
    }
}

