/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho.parser.draw;

import org.jfree.report.structure.Element;
import org.libreoffice.report.pentaho.model.ObjectOleElement;
import org.libreoffice.report.pentaho.parser.ElementReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ObjectOleReadHandler
extends ElementReadHandler {
    private static final String RPT_CHART_CLASS_ID = "80243D39-6741-46C5-926E-069164FF87BB";
    private static final String OOO_CHART_CLASS_ID = "12DCAE26-281F-416F-A234-C3086127382E";
    private final ObjectOleElement element;

    public ObjectOleReadHandler(ObjectOleElement element) {
        this.element = element;
    }

    protected void startParsing(Attributes attrs) throws SAXException {
        String classid;
        super.startParsing(attrs);
        String url = attrs.getValue("http://www.w3.org/1999/xlink", "href");
        if (url != null) {
            this.element.setUrl(url);
        }
        if ((classid = attrs.getValue("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "class-id")) != null) {
            if (classid.equalsIgnoreCase(RPT_CHART_CLASS_ID)) {
                classid = OOO_CHART_CLASS_ID;
            }
            this.element.setClassId(classid);
        }
    }

    public Element getElement() {
        return this.element;
    }
}

