<xsl:stylesheet version = '1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>

<!--
  - This Extensible Stylesheet Language Transformation file translates XML files
  - as generated by KBibTeX into nice HTML code.
  -
  - This file was written by Thomas Fischer <fischer@unix-ag.uni-kl.de>
  - It is released under the GNU Public License version 2 or later.
  -->

<xsl:output omit-xml-declaration="yes" indent="no" encoding="UTF-8"/>

<!-- ==============================================================================
     Maintain original HTML tags
-->
<xsl:template match="a|abbr|acronym|address|applet|b|big|blockquote|br|cite|code|del|dfn|div|em|hr|i|kbd|p|param|pre|q|quote|samp|script|span|small|strike|strong|sub|sup|tt|var|button|fieldset|form|input|label|legend|object|option|optgroup|select|caption|col|colgroup|table|tbody|td|tfoot|th|thead|tr|dl|dd|dt|ol|ul|li|img|quote|quotation" xmlns:html="http://www.w3.org/1999/XSL/some">
<xsl:copy>
<xsl:copy-of select="@*" />
<xsl:apply-templates />
</xsl:copy>
</xsl:template>



<xsl:template match="text">
<xsl:apply-templates />
</xsl:template>

<xsl:template match="person">
<a style="text-decoration: none; color: black;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:author=</xsl:text><xsl:value-of select="lastname"/></xsl:attribute>
<xsl:value-of select="lastname"/><xsl:if test="string-length(firstname)>0"><xsl:text>, </xsl:text>
<xsl:value-of select="substring(firstname,1,1)"/><xsl:text>.</xsl:text></xsl:if>
</a>
</xsl:template>

<xsl:template match="authors">
<xsl:if test="string-length(.)>0">
<xsl:for-each select="person">
<span style="font-weight:bold;">
<xsl:apply-templates select="."/>
</span>
<xsl:if test="position()!=last()"><xsl:text>, </xsl:text>
</xsl:if>
<xsl:if test="position()=last()-1 and @etal!='true'">
<xsl:text> and </xsl:text>
</xsl:if>
</xsl:for-each>
<xsl:if test="@etal='true'"><xsl:text> </xsl:text><i>et&#160;al.</i></xsl:if>
</xsl:if>
</xsl:template>

<xsl:template match="editors">
<xsl:for-each select="person">
<xsl:apply-templates /><xsl:if test="position()!=last()"><xsl:text>, </xsl:text>
</xsl:if>
<xsl:if test="position()=last()-1 and @etal!='true'"><xsl:text> and </xsl:text></xsl:if>
</xsl:for-each>
<xsl:if test="@etal='true'"><xsl:text> </xsl:text><i>et&#160;al.</i></xsl:if>
<xsl:text>, </xsl:text>
</xsl:template>

<xsl:template match="title">
<a style="text-decoration: none; color: #000;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:title=</xsl:text><xsl:value-of select="."/></xsl:attribute><xsl:value-of select="."/></a>
</xsl:template>

<xsl:template match="booktitle">
<i><a style="text-decoration: none; color: white;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:booktitle=</xsl:text><xsl:value-of select="."/></xsl:attribute><xsl:value-of select="."/></a></i>
</xsl:template>

<xsl:template match="journal">
<a style="text-decoration: none; color: white; font-style:italic;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:journal=</xsl:text><xsl:value-of select="."/></xsl:attribute><xsl:value-of select="."/></a>
<xsl:if test="string-length(../volume)>0">
<xsl:text> </xsl:text>
<a style="text-decoration: none; color: white;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:volume=</xsl:text><xsl:value-of select="../volume"/></xsl:attribute><xsl:value-of select="../volume"/></a>
<xsl:if test="string-length(../number)>0">
<xsl:text>(</xsl:text>
<a style="text-decoration: none; color: white;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:number=</xsl:text><xsl:value-of select="../number"/></xsl:attribute><xsl:value-of select="../number"/></a>
<xsl:text>)</xsl:text>
</xsl:if>
</xsl:if>
</xsl:template>

<xsl:template match="publisher">
<a style="text-decoration: none; color: white;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:publisher=</xsl:text><xsl:value-of select="."/></xsl:attribute><xsl:value-of select="."/></a>
<xsl:text>, </xsl:text>
</xsl:template>

<xsl:template match="volume">
<xsl:text>volume </xsl:text>
<a style="text-decoration: none; color: white;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:volume=</xsl:text><xsl:value-of select="."/></xsl:attribute><xsl:value-of select="."/></a>
<xsl:text>, </xsl:text>
</xsl:template>

<xsl:template match="edition">
<a style="text-decoration: none; color: white;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:edition=</xsl:text><xsl:value-of select="."/></xsl:attribute><xsl:value-of select="."/></a>
<xsl:text> edition, </xsl:text>
</xsl:template>

<xsl:template match="pages">
<xsl:text>, </xsl:text>
<a style="text-decoration: none; color: white;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:pages=</xsl:text><xsl:value-of select="."/></xsl:attribute><xsl:value-of select="."/></a>
</xsl:template>

<xsl:template match="year">
<a style="text-decoration: none; color: white;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:year=</xsl:text><xsl:value-of select="."/></xsl:attribute><xsl:value-of select="."/></a>
</xsl:template>

<xsl:template match="note">
<xsl:text>, </xsl:text>
<a style="text-decoration: none; color: white;"><xsl:attribute name="href"><xsl:text>kbibtex:filter:note=</xsl:text><xsl:value-of select="."/></xsl:attribute><xsl:value-of select="."/></a>
</xsl:template>

<xsl:template match="month">
<xsl:value-of select="."/>
</xsl:template>

<xsl:template match="abstract">
<i>Abstract</i><xsl:text>: </xsl:text><xsl:apply-templates />
</xsl:template>

<xsl:template match="entry">
<div style="margin:0px; padding: 0.5ex; border-top: solid 0.25ex #c00;"><xsl:apply-templates select="authors" /></div>
<div style="margin:0px; padding: 0.5ex; background: #ec6; font-size: 125%;">
<xsl:apply-templates select="title" />
</div>
<xsl:if test="string-length(journal)>0 or string-length(booktitle)>0 or string-length(year)>0">
<div style="margin:0px; padding: 0.5ex; background: #900; color: white;">
<xsl:if test="string-length(journal)>0"><xsl:apply-templates select="journal" /></xsl:if>
<xsl:if test="string-length(booktitle)>0"><xsl:apply-templates select="booktitle" /></xsl:if>
<xsl:if test="( string-length(journal)>0 or string-length(booktitle)>0 ) and string-length(year)>0"><xsl:text>, </xsl:text></xsl:if>
<xsl:if test="string-length(year)>0">
<xsl:if test="string-length(month)>0"><xsl:value-of select="month" /><xsl:text> </xsl:text></xsl:if>
<xsl:apply-templates select="year" />
<xsl:apply-templates select="pages" />
</xsl:if>
<xsl:apply-templates select="note" />
</div>
</xsl:if>
<xsl:if test="string-length(abstract)>0">
<div style="margin:0px; padding: 0.5ex; padding-top: 1ex; text-align: justify; font-size: 80%; color: #333;">
<xsl:apply-templates select="abstract" />
</div>
</xsl:if>
</xsl:template>

<xsl:template match="bibliography">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
<head>
<title>Bibliography</title>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
</head>
<body style="margin:0px; padding: 0px;">
<xsl:apply-templates select="entry" />
</body>
</html>
</xsl:template>

</xsl:stylesheet>
