// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GTKSOURCEVIEWMM_SOURCESTYLESCHEME_H
#define _GTKSOURCEVIEWMM_SOURCESTYLESCHEME_H


#include <glibmm.h>

/* sourcestylescheme.h
 *
 * Copyright (C) 2004-2005 Jae Jang
 * Copyright (C) 2005-2006 Rob Page
 * Copyright (C) 2006 Dodji Seketeli
 * Copyright (C) 2009, 2010 Krzesimir Nowak
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/interface.h>
#include <gtksourceviewmm/sourcestyle.h>
#include <gtksourceview/gtksourcestylescheme.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSourceStyleScheme GtkSourceStyleScheme;
typedef struct _GtkSourceStyleSchemeClass GtkSourceStyleSchemeClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace gtksourceview
{ class SourceStyleScheme_Class; } // namespace gtksourceview
namespace gtksourceview
{


/** Object controlling apperance of SourceView.
 *
 * SourceStyleScheme contains all the text styles to be used in SourceView and
 * SourceBuffer. For instance, it contains text styles for syntax highlighting,
 * it may contain foreground and background color for non-highlighted text,
 * color for the line numbers, etc.
 *
 * Style schemes are stored in XML files. The format of a scheme file is
 * the documented in the C library gtksourceview documentation.
 *
 * @newin{2,2}
 */

class SourceStyleScheme : public Glib::Interface
{

  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef SourceStyleScheme CppObjectType;
  typedef SourceStyleScheme_Class CppClassType;
  typedef GtkSourceStyleScheme BaseObjectType;
  typedef GTypeInterface BaseClassType;

private:
  friend class SourceStyleScheme_Class;
  static CppClassType sourcestylescheme_class_;

  // noncopyable
  SourceStyleScheme(const SourceStyleScheme&);
  SourceStyleScheme& operator=(const SourceStyleScheme&);

protected:
  SourceStyleScheme(); // you must derive from this class

  /** Called by constructors of derived classes. Provide the result of 
   * the Class init() function to ensure that it is properly 
   * initialized.
   * 
   * @param interface_class The Class object for the derived type.
   */
  explicit SourceStyleScheme(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface. 
  explicit SourceStyleScheme(GtkSourceStyleScheme* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~SourceStyleScheme();

  static void add_interface(GType gtype_implementer);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSourceStyleScheme*       gobj()       { return reinterpret_cast<GtkSourceStyleScheme*>(gobject_); }

  ///Provides access to the underlying C GObject.  
  const GtkSourceStyleScheme* gobj() const { return reinterpret_cast<GtkSourceStyleScheme*>(gobject_); }

private:


public:

  
  /** Gets scheme id.
   *
   * @return Scheme id.
   *
   * @newin{2,2}
   */
  Glib::ustring get_id() const;

  
  /** Gets scheme name.
   *
   * @return Scheme name.
   *
   * @newin{2,2}
   */
  Glib::ustring get_name() const;

  
  /** Gets scheme description.
   *
   * @return Scheme description.
   *
   * @newin{2,2}
   */
  Glib::ustring get_description() const;

 
  /** Gets scheme authors.
   *
   * @return Array with scheme authors.
   *
   * @newin{2,2}
   */
  Glib::StringArrayHandle get_authors() const;

  
  /** Gets scheme filename.
   *
   * @return Scheme file name if the scheme was created parsing a style scheme
   * file or empty string in the other cases.
   *
   * @newin{2,2}
   */
  std::string get_filename() const;

  
  /** Gets style corresponding to @a style_id in scheme.
   *
   * @param style_id Id of the style to retrieve.
   *
   * @return Style which corresponds to @a style_id in the scheme,
   * or empty Glib::RefPtr when no style with this name found.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<SourceStyle> get_style(const Glib::ustring& style_id);

  
  /** Gets style corresponding to @a style_id in scheme.
   *
   * @param style_id Id of the style to retrieve.
   *
   * @return Style which corresponds to @a style_id in the scheme,
   * or empty Glib::RefPtr when no style with this name found.
   *
   * @newin{2,2}
   */
  Glib::RefPtr<const SourceStyle> get_style(const Glib::ustring& style_id) const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};//end class SourceStyleScheme

}//end namespace gtksourceview


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates gtksourceview::SourceStyleScheme
   */
  Glib::RefPtr<gtksourceview::SourceStyleScheme> wrap(GtkSourceStyleScheme* object, bool take_copy = false);

} // namespace Glib


#endif /* _GTKSOURCEVIEWMM_SOURCESTYLESCHEME_H */

