/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.encryption;

import java.io.InputStream;
import org.bouncycastle.crypto.StreamCipher;
import org.bouncycastle.crypto.engines.RC4Engine;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.params.KeyParameter;
import org.sejda.sambox.encryption.EncryptionAlgorithmEngine;

class ARC4Engine
implements EncryptionAlgorithmEngine {
    private StreamCipher cipher = new RC4Engine();

    @Override
    public InputStream encryptStream(InputStream data, byte[] key) {
        this.init(key);
        return new CipherInputStream(data, this.cipher);
    }

    @Override
    public byte[] encryptBytes(byte[] data, byte[] key) {
        this.init(key);
        byte[] out = new byte[data.length];
        this.cipher.processBytes(data, 0, data.length, out, 0);
        return out;
    }

    private void init(byte[] key) {
        this.cipher.init(true, new KeyParameter(key));
    }
}

