/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class ToolbarLayout
implements LayoutManager,
Serializable {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    int align;
    int hgap;
    int vgap;

    public ToolbarLayout() {
        this(0, 5, 5);
    }

    public ToolbarLayout(int n) {
        this(n, 5, 5);
    }

    public ToolbarLayout(int n, int n2, int n3) {
        this.align = n;
        this.hgap = n2;
        this.vgap = n3;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setAlignment(int n) {
        this.align = n;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int n) {
        this.hgap = n;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int n) {
        this.vgap = n;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension preferredLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = 1;
            int n3 = insets.left + insets.right;
            int n4 = container.getSize().width;
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getPreferredSize();
                n5 = Math.max(n5, dimension2.height);
                if (i > 0) {
                    n3 += this.hgap;
                }
                if ((n3 += dimension2.width) + this.hgap > n4 && n6 > 0) {
                    ++n2;
                    n3 = insets.left + insets.right + dimension2.width;
                    n6 = 0;
                }
                ++n6;
            }
            dimension.width = n4;
            dimension.height = insets.top + insets.bottom + n2 * n5 + this.vgap * (n2 + 1);
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension minimumLayoutSize(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Dimension dimension = new Dimension(0, 0);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension2 = component.getMinimumSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                if (i > 0) {
                    dimension.width += this.hgap;
                }
                dimension.width += dimension2.width;
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right + this.hgap * 2;
            dimension.height += insets.top + insets.bottom + this.vgap * 2;
            return dimension;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container container, int n, int n2, int n3, int n4, int n5, int n6) {
        Object object = container.getTreeLock();
        synchronized (object) {
            switch (this.align) {
                case 0: {
                    break;
                }
                case 1: {
                    n += n3 / 2;
                    break;
                }
                case 2: {
                    n += n3;
                }
            }
            for (int i = n5; i < n6; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                component.setLocation(n, n2 + (n4 - component.size().height) / 2);
                n += this.hgap + component.size().width;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Insets insets = container.getInsets();
            int n = container.size().width - (insets.left + insets.right + this.hgap * 2);
            int n2 = container.getComponentCount();
            int n3 = 0;
            int n4 = insets.top + this.vgap;
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < n2; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                component.setSize(dimension.width, dimension.height);
                if (n3 == 0 || n3 + dimension.width <= n) {
                    if (n3 > 0) {
                        n3 += this.hgap;
                    }
                    n3 += dimension.width;
                    n5 = Math.max(n5, dimension.height);
                    continue;
                }
                this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, i);
                n3 = dimension.width;
                n4 += this.vgap + n5;
                n5 = dimension.height;
                n6 = i;
            }
            this.moveComponents(container, insets.left + this.hgap, n4, n - n3, n5, n6, n2);
        }
    }

    public String toString() {
        String string = "";
        switch (this.align) {
            case 0: {
                string = ",align=left";
                break;
            }
            case 1: {
                string = ",align=center";
                break;
            }
            case 2: {
                string = ",align=right";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + string + "]";
    }
}

