/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.payloads;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.payloads.PayloadFunction;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.search.spans.SpanWeight;
import org.apache.lucene.search.spans.TermSpans;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public class PayloadTermQuery
extends SpanTermQuery {
    protected PayloadFunction function;
    private boolean includeSpanScore;

    public PayloadTermQuery(Term term, PayloadFunction function) {
        this(term, function, true);
    }

    public PayloadTermQuery(Term term, PayloadFunction function, boolean includeSpanScore) {
        super(term);
        this.function = Objects.requireNonNull(function);
        this.includeSpanScore = includeSpanScore;
    }

    @Override
    public SpanWeight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new PayloadTermWeight(this, searcher, needsScores);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.function.hashCode();
        result = 31 * result + (this.includeSpanScore ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        PayloadTermQuery other = (PayloadTermQuery)obj;
        return this.includeSpanScore == other.includeSpanScore && this.function.equals(other.function);
    }

    protected class PayloadTermWeight
    extends SpanWeight {
        public PayloadTermWeight(PayloadTermQuery query, IndexSearcher searcher, boolean needsScores) throws IOException {
            super(query, searcher, needsScores);
        }

        @Override
        public PayloadTermSpanScorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
            TermSpans spans = (TermSpans)this.query.getSpans(context, acceptDocs, this.termContexts);
            return spans == null ? null : new PayloadTermSpanScorer(spans, this, this.similarity.simScorer(this.stats, context));
        }

        @Override
        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            int newDoc;
            PayloadTermSpanScorer scorer = this.scorer(context, context.reader().getLiveDocs());
            if (scorer != null && (newDoc = scorer.advance(doc)) == doc) {
                float freq = scorer.sloppyFreq();
                Explanation freqExplanation = Explanation.match(freq, "phraseFreq=" + freq, new Explanation[0]);
                Similarity.SimScorer docScorer = this.similarity.simScorer(this.stats, context);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                Explanation expl = Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
                String field = ((SpanQuery)this.getQuery()).getField();
                Explanation payloadExpl = PayloadTermQuery.this.function.explain(doc, field, scorer.payloadsSeen, scorer.payloadScore);
                if (PayloadTermQuery.this.includeSpanScore) {
                    return Explanation.match(expl.getValue() * payloadExpl.getValue(), "btq, product of:", expl, payloadExpl);
                }
                return Explanation.match(payloadExpl.getValue(), "btq(includeSpanScore=false), result of:", payloadExpl);
            }
            return Explanation.noMatch("no matching term", new Explanation[0]);
        }

        protected class PayloadTermSpanScorer
        extends SpanScorer {
            protected BytesRef payload;
            protected float payloadScore;
            protected int payloadsSeen;
            private final TermSpans termSpans;

            public PayloadTermSpanScorer(TermSpans spans, SpanWeight weight, Similarity.SimScorer docScorer) throws IOException {
                super(spans, weight, docScorer);
                this.termSpans = spans;
            }

            @Override
            protected void setFreqCurrentDoc() throws IOException {
                this.freq = 0.0f;
                this.numMatches = 0;
                this.payloadScore = 0.0f;
                this.payloadsSeen = 0;
                int startPos = this.spans.nextStartPosition();
                assert (startPos != Integer.MAX_VALUE) : "initial startPos NO_MORE_POSITIONS, spans=" + this.spans;
                do {
                    int matchLength = this.spans.endPosition() - startPos;
                    this.freq += this.docScorer.computeSlopFactor(matchLength);
                    ++this.numMatches;
                    this.processPayload(PayloadTermWeight.this.similarity);
                } while ((startPos = this.spans.nextStartPosition()) != Integer.MAX_VALUE);
            }

            protected void processPayload(Similarity similarity) throws IOException {
                if (this.spans.isPayloadAvailable()) {
                    PostingsEnum postings = this.termSpans.getPostings();
                    this.payload = postings.getPayload();
                    this.payloadScore = this.payload != null ? PayloadTermQuery.this.function.currentScore(this.docID(), PayloadTermQuery.this.term.field(), this.spans.startPosition(), this.spans.endPosition(), this.payloadsSeen, this.payloadScore, this.docScorer.computePayloadFactor(this.docID(), this.spans.startPosition(), this.spans.endPosition(), this.payload)) : PayloadTermQuery.this.function.currentScore(this.docID(), PayloadTermQuery.this.term.field(), this.spans.startPosition(), this.spans.endPosition(), this.payloadsSeen, this.payloadScore, 1.0f);
                    ++this.payloadsSeen;
                }
            }

            @Override
            public float scoreCurrentDoc() throws IOException {
                return PayloadTermQuery.this.includeSpanScore ? this.getSpanScore() * this.getPayloadScore() : this.getPayloadScore();
            }

            protected float getSpanScore() throws IOException {
                return super.scoreCurrentDoc();
            }

            protected float getPayloadScore() {
                return PayloadTermQuery.this.function.docScore(this.docID(), PayloadTermQuery.this.term.field(), this.payloadsSeen, this.payloadScore);
            }
        }
    }
}

