/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;

public final class RegexNameFinder
implements TokenNameFinder {
    private Pattern[] mPatterns;
    private String sType;
    private Map<String, Pattern[]> regexMap;

    public RegexNameFinder(Map<String, Pattern[]> regexMap) {
        if (regexMap == null) {
            throw new IllegalArgumentException("regexNameFinders must not be null");
        }
        this.regexMap = regexMap;
    }

    public RegexNameFinder(Pattern[] patterns, String type) {
        if (patterns == null || patterns.length == 0) {
            throw new IllegalArgumentException("patterns must not be null or empty!");
        }
        this.mPatterns = patterns;
        this.sType = type;
    }

    @Deprecated
    public RegexNameFinder(Pattern[] patterns) {
        if (patterns == null || patterns.length == 0) {
            throw new IllegalArgumentException("patterns must not be null or empty!");
        }
        this.mPatterns = patterns;
        this.sType = null;
    }

    @Override
    public Span[] find(String[] tokens) {
        HashMap<Integer, Integer> sentencePosTokenMap = new HashMap<Integer, Integer>();
        StringBuffer sentenceString = new StringBuffer(tokens.length * 10);
        for (int i = 0; i < tokens.length; ++i) {
            int startIndex = sentenceString.length();
            sentencePosTokenMap.put(startIndex, i);
            sentenceString.append(tokens[i]);
            int endIndex = sentenceString.length();
            sentencePosTokenMap.put(endIndex, i + 1);
            if (i >= tokens.length - 1) continue;
            sentenceString.append(' ');
        }
        LinkedList<Span> annotations = new LinkedList<Span>();
        if (this.mPatterns == null && this.regexMap != null) {
            for (Map.Entry<String, Pattern[]> entry : this.regexMap.entrySet()) {
                for (Pattern mPattern : entry.getValue()) {
                    Matcher matcher = mPattern.matcher(sentenceString);
                    while (matcher.find()) {
                        Integer tokenStartIndex = (Integer)sentencePosTokenMap.get(matcher.start());
                        Integer tokenEndIndex = (Integer)sentencePosTokenMap.get(matcher.end());
                        if (tokenStartIndex == null || tokenEndIndex == null) continue;
                        Span annotation = new Span((int)tokenStartIndex, (int)tokenEndIndex, entry.getKey());
                        annotations.add(annotation);
                    }
                }
            }
        } else {
            for (Pattern mPattern : this.mPatterns) {
                Matcher matcher = mPattern.matcher(sentenceString);
                while (matcher.find()) {
                    Integer tokenStartIndex = (Integer)sentencePosTokenMap.get(matcher.start());
                    Integer tokenEndIndex = (Integer)sentencePosTokenMap.get(matcher.end());
                    if (tokenStartIndex == null || tokenEndIndex == null) continue;
                    Span annotation = new Span((int)tokenStartIndex, (int)tokenEndIndex, this.sType);
                    annotations.add(annotation);
                }
            }
        }
        return annotations.toArray(new Span[annotations.size()]);
    }

    public Span[] find(String text) {
        return this.getAnnotations(text);
    }

    private Span[] getAnnotations(String text) {
        LinkedList<Span> annotations = new LinkedList<Span>();
        if (this.mPatterns == null && this.regexMap != null) {
            for (Map.Entry<String, Pattern[]> entry : this.regexMap.entrySet()) {
                for (Pattern mPattern : entry.getValue()) {
                    Matcher matcher = mPattern.matcher(text);
                    while (matcher.find()) {
                        Integer tokenStartIndex = matcher.start();
                        Integer tokenEndIndex = matcher.end();
                        Span annotation = new Span((int)tokenStartIndex, (int)tokenEndIndex, entry.getKey());
                        annotations.add(annotation);
                    }
                }
            }
        } else {
            for (Pattern mPattern : this.mPatterns) {
                Matcher matcher = mPattern.matcher(text);
                while (matcher.find()) {
                    Integer tokenStartIndex = matcher.start();
                    Integer tokenEndIndex = matcher.end();
                    Span annotation = new Span((int)tokenStartIndex, (int)tokenEndIndex, this.sType);
                    annotations.add(annotation);
                }
            }
        }
        return annotations.toArray(new Span[annotations.size()]);
    }

    @Override
    public void clearAdaptiveData() {
    }

    public Pattern[] getmPatterns() {
        return this.mPatterns;
    }

    public void setmPatterns(Pattern[] mPatterns) {
        this.mPatterns = mPatterns;
    }

    public String getsType() {
        return this.sType;
    }

    public void setsType(String sType) {
        this.sType = sType;
    }
}

