/*
 * <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2014  <copyright holder> <email>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

#ifndef FM_DNDDEST_H
#define FM_DNDDEST_H

#include <QMimeData>
#include "path.h"

namespace Fm {

class DndDest {
public:
  DndDest();
  ~DndDest();

  void setDestPath(FmPath* dest) {
    destPath_ = dest;
  }

  const Path& destPath() {
    return destPath_;
  }

  bool isSupported(const QMimeData* data);
  bool isSupported(QString mimeType);

  bool dropMimeData(const QMimeData* data, Qt::DropAction action);

private:
  Path destPath_;
};

}

#endif // FM_DNDDEST_H
