/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.VariableRemapper;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.info.ParameterUsageMarker;

public class ParameterShrinker
extends SimplifiedVisitor
implements AttributeVisitor {
    private static final boolean DEBUG = false;
    private final MemberVisitor extraVariableMemberVisitor;
    private final VariableRemapper variableRemapper = new VariableRemapper();

    public ParameterShrinker() {
        this(null);
    }

    public ParameterShrinker(MemberVisitor memberVisitor) {
        this.extraVariableMemberVisitor = memberVisitor;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int n;
        int n2 = ParameterUsageMarker.getParameterSize(method);
        if (n2 > (n = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags()))) {
            int n3;
            int n4 = codeAttribute.u2maxLocals;
            int[] nArray = new int[n4];
            int n5 = 0;
            int n6 = n;
            for (n3 = 0; n3 < n2; ++n3) {
                if (ParameterUsageMarker.isParameterUsed(method, n3)) {
                    nArray[n3] = n5++;
                    continue;
                }
                nArray[n3] = n6++;
                if (this.extraVariableMemberVisitor == null) continue;
                method.accept(clazz, this.extraVariableMemberVisitor);
            }
            for (n3 = n2; n3 < n4; ++n3) {
                nArray[n3] = n3;
            }
            this.variableRemapper.setVariableMap(nArray);
            this.variableRemapper.visitCodeAttribute(clazz, method, codeAttribute);
        }
    }
}

