/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.lang.ref.WeakReference;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.network.HttpMessage;

public class HttpMessageCachedData {
    private final String method;
    private final URI uri;
    private final String reason;
    private final int statusCode;
    private final int rtt;
    private final long timeSentMillis;
    private final int requestHeaderLength;
    private final int requestBodyLength;
    private final int responseHeaderLength;
    private final int responseBodyLength;
    private boolean note;
    private WeakReference<String> wrRequestBody;

    public HttpMessageCachedData(HttpMessage httpMessage) {
        this.method = httpMessage.getRequestHeader().getMethod();
        this.uri = httpMessage.getRequestHeader().getURI();
        this.statusCode = httpMessage.getResponseHeader().getStatusCode();
        this.reason = httpMessage.getResponseHeader().getReasonPhrase();
        this.rtt = httpMessage.getTimeElapsedMillis();
        this.note = httpMessage.getNote() != null && httpMessage.getNote().length() > 0;
        this.timeSentMillis = httpMessage.getTimeSentMillis();
        this.requestHeaderLength = httpMessage.getRequestHeader().toString().length();
        this.requestBodyLength = httpMessage.getRequestBody().length();
        this.responseHeaderLength = httpMessage.getResponseHeader().toString().length();
        this.responseBodyLength = httpMessage.getResponseBody().length();
        this.wrRequestBody = new WeakReference<String>(httpMessage.getRequestBody().toString());
    }

    public String getMethod() {
        return this.method;
    }

    public URI getUri() {
        return this.uri;
    }

    public String getReason() {
        return this.reason;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public int getRtt() {
        return this.rtt;
    }

    public boolean hasNote() {
        return this.note;
    }

    public void setNote(boolean bl) {
        this.note = bl;
    }

    public long getTimeSentMillis() {
        return this.timeSentMillis;
    }

    public long getTimeReceivedMillis() {
        return this.timeSentMillis + (long)this.rtt;
    }

    public int getRequestHeaderLength() {
        return this.requestHeaderLength;
    }

    public int getRequestBodyLength() {
        return this.requestBodyLength;
    }

    public int getResponseHeaderLength() {
        return this.responseHeaderLength;
    }

    public int getResponseBodyLength() {
        return this.responseBodyLength;
    }

    public String getRequestBody() {
        return (String)this.wrRequestBody.get();
    }

    public void setRequestBody(String string) {
        this.wrRequestBody.clear();
        this.wrRequestBody = new WeakReference<String>(string);
    }
}

