/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.model;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.view.View;

public class SiteNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 7987615016786179150L;
    private String nodeName = null;
    private String hierarchicNodeName = null;
    private HistoryReference historyReference = null;
    private Vector<HistoryReference> pastHistoryList = new Vector(10);
    private SiteMap siteMap = null;
    private ArrayList<Alert> alerts = new ArrayList();
    private boolean justSpidered = false;
    private ArrayList<String> icons = null;
    private ArrayList<Boolean> clearIfManual = null;
    private static Logger log = Logger.getLogger(SiteNode.class);
    private boolean isIncludedInScope = false;
    private boolean isExcludedFromScope = false;
    private boolean filtered = false;
    private boolean dataDriven = false;

    public SiteNode(SiteMap siteMap, int n, String string) {
        this.siteMap = siteMap;
        this.nodeName = string;
        if (string.startsWith("\u00ab")) {
            this.dataDriven = true;
        }
        this.icons = new ArrayList();
        this.clearIfManual = new ArrayList();
        if (n == 2) {
            this.justSpidered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomIcons(ArrayList<String> arrayList, ArrayList<Boolean> arrayList2) {
        ArrayList<String> arrayList3 = this.icons;
        synchronized (arrayList3) {
            this.icons.clear();
            this.icons.addAll(arrayList);
            this.clearIfManual = arrayList2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomIcon(String string, boolean bl) {
        ArrayList<String> arrayList = this.icons;
        synchronized (arrayList) {
            if (!this.icons.contains(string)) {
                this.icons.add(string);
                this.clearIfManual.add(bl);
                this.nodeChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomIcon(String string) {
        ArrayList<String> arrayList = this.icons;
        synchronized (arrayList) {
            if (this.icons.contains(string)) {
                int n = this.icons.indexOf(string);
                this.icons.remove(n);
                this.clearIfManual.remove(n);
                this.nodeChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendIcons(StringBuilder stringBuilder) {
        int n = -1;
        Alert alert = null;
        for (Alert object : this.getAlerts()) {
            if (object.getConfidence() == 0 || object.getRisk() <= n) continue;
            n = object.getRisk();
            alert = object;
        }
        if (alert != null) {
            stringBuilder.append("&nbsp;<img src=\"");
            stringBuilder.append(alert.getIconUrl());
            stringBuilder.append("\">&nbsp;");
        }
        if (this.justSpidered) {
            stringBuilder.append("&nbsp;<img src=\"");
            stringBuilder.append(Constant.class.getResource("/resource/icon/10/spider.png"));
            stringBuilder.append("\">&nbsp;");
        }
        ArrayList<String> arrayList = this.icons;
        synchronized (arrayList) {
            if (!this.icons.isEmpty()) {
                for (String string : this.icons) {
                    stringBuilder.append("&nbsp;<img src=\"");
                    stringBuilder.append(Constant.class.getResource(string));
                    stringBuilder.append("\">&nbsp;");
                }
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html><body>");
        this.appendIcons(stringBuilder);
        stringBuilder.append(StringEscapeUtils.escapeHtml(this.nodeName));
        stringBuilder.append("</body></html>");
        return stringBuilder.toString();
    }

    public boolean isParentOf(String string) {
        if (string == null) {
            return false;
        }
        return string.compareTo(this.nodeName) < 0;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public String getCleanNodeName() {
        return this.getCleanNodeName(true);
    }

    public String getCleanNodeName(boolean bl) {
        String string = this.getNodeName();
        if (bl && this.isDataDriven()) {
            string = "(.+?)";
        } else if (this.isLeaf()) {
            int n;
            int n2;
            int n3 = string.indexOf(":");
            if (n3 > 0) {
                string = string.substring(n3 + 1);
            }
            if ((n2 = string.lastIndexOf("(")) > 0) {
                string = string.substring(0, n2);
            }
            if ((n = string.indexOf("?")) > 0) {
                string = string.substring(0, n);
            }
        }
        return string;
    }

    public String getHierarchicNodeName() {
        return this.getHierarchicNodeName(true);
    }

    public String getHierarchicNodeName(boolean bl) {
        if (this.hierarchicNodeName != null && bl) {
            return this.hierarchicNodeName;
        }
        if (this.isRoot()) {
            this.hierarchicNodeName = "";
        } else if (this.getParent().isRoot()) {
            this.hierarchicNodeName = this.getNodeName();
        } else {
            String string = this.getParent().getHierarchicNodeName(bl) + "/" + this.getCleanNodeName(bl);
            if (!bl) {
                return string;
            }
            this.hierarchicNodeName = string;
        }
        return this.hierarchicNodeName;
    }

    public HistoryReference getHistoryReference() {
        return this.historyReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHistoryReference(HistoryReference historyReference) {
        if (this.getHistoryReference() != null) {
            if (this.justSpidered && (historyReference.getHistoryType() == 1 || historyReference.getHistoryType() == 15)) {
                this.justSpidered = false;
                this.nodeChanged();
            }
            if (!(this.icons.isEmpty() || historyReference.getHistoryType() != 1 && historyReference.getHistoryType() != 15)) {
                ArrayList<String> arrayList = this.icons;
                synchronized (arrayList) {
                    for (int i = 0; i < this.clearIfManual.size(); ++i) {
                        if (!this.clearIfManual.get(i).booleanValue() || this.icons.size() <= i) continue;
                        this.icons.remove(i);
                        this.clearIfManual.remove(i);
                    }
                }
                this.nodeChanged();
            }
            if (3 == historyReference.getHistoryType()) {
                this.getPastHistoryReference().add(historyReference);
                return;
            }
            if (!this.getPastHistoryReference().contains(this.getHistoryReference())) {
                this.getPastHistoryReference().add(this.getHistoryReference());
            }
        }
        this.historyReference = historyReference;
        this.historyReference.setSiteNode(this);
    }

    private void nodeChanged() {
        if (this.siteMap == null || !View.isInitialised()) {
            return;
        }
        if (EventQueue.isDispatchThread()) {
            this.nodeChangedEventHandler();
        } else {
            try {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SiteNode.this.nodeChangedEventHandler();
                    }
                });
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private void nodeChangedEventHandler() {
        this.siteMap.nodeChanged(this);
    }

    public Vector<HistoryReference> getPastHistoryReference() {
        return this.pastHistoryList;
    }

    public boolean hasAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        for (Alert alert2 : this.getAlerts()) {
            if (!alert2.equals(alert)) continue;
            return true;
        }
        return false;
    }

    public void addAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        if (this.hasAlert(alert)) {
            return;
        }
        this.alerts.add(alert);
        if (this.getParent() != null) {
            this.getParent().addAlert(alert);
        }
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
    }

    public void updateAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        Alert alert2 = null;
        for (Alert alert3 : this.getAlerts()) {
            if (alert3.getAlertId() != alert.getAlertId()) continue;
            alert2 = alert3;
            break;
        }
        if (alert2 != null) {
            this.alerts.remove(alert2);
            this.alerts.add(alert);
            if (this.getParent() != null) {
                this.getParent().updateAlert(alert);
            }
            if (this.siteMap != null) {
                this.siteMap.applyFilter(this);
            }
            this.nodeChanged();
        }
    }

    public List<Alert> getAlerts() {
        return (List)this.alerts.clone();
    }

    private void clearChildAlert(Alert alert, SiteNode siteNode) {
        boolean bl = true;
        this.alerts.remove(alert);
        if (this.getChildCount() > 0) {
            SiteNode siteNode2 = (SiteNode)this.getFirstChild();
            while (siteNode2 != null) {
                if (!siteNode2.equals(siteNode) && siteNode2.hasAlert(alert)) {
                    this.alerts.add(alert);
                    bl = false;
                    break;
                }
                siteNode2 = (SiteNode)this.getChildAfter(siteNode2);
            }
        }
        if (bl && this.getParent() != null) {
            this.getParent().clearChildAlert(alert, this);
        }
    }

    public void deleteAlert(Alert alert) {
        if (alert == null) {
            throw new IllegalArgumentException("Alert must not be null");
        }
        this.alerts.remove(alert);
        if (this.getParent() != null) {
            this.getParent().clearChildAlert(alert, this);
        }
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
    }

    public void deleteAlerts(List<Alert> list) {
        ArrayList<Alert> arrayList = new ArrayList<Alert>(list);
        if (this.alerts.removeAll(arrayList)) {
            if (this.getParent() != null) {
                this.getParent().clearChildAlerts(arrayList);
            }
            if (this.siteMap != null) {
                this.siteMap.applyFilter(this);
            }
            this.nodeChanged();
        }
    }

    public void deleteAllAlerts() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((SiteNode)this.getChildAt(i)).deleteAllAlerts();
        }
        if (!this.alerts.isEmpty()) {
            this.alerts.clear();
            if (this.siteMap != null) {
                this.siteMap.applyFilter(this);
            }
            this.nodeChanged();
        }
    }

    private void clearChildAlerts(List<Alert> list) {
        boolean bl;
        ArrayList<Alert> arrayList = new ArrayList<Alert>(list);
        if (this.getChildCount() > 0) {
            SiteNode siteNode = (SiteNode)this.getFirstChild();
            while (siteNode != null) {
                arrayList.removeAll(siteNode.alerts);
                siteNode = (SiteNode)this.getChildAfter(siteNode);
            }
        }
        if (bl = this.alerts.removeAll(arrayList)) {
            if (this.getParent() != null) {
                this.getParent().clearChildAlerts(arrayList);
            }
            this.nodeChangedEventHandler();
        }
    }

    public boolean hasHistoryType(int n) {
        if (this.historyReference == null) {
            return false;
        }
        if (this.historyReference.getHistoryType() == n) {
            return true;
        }
        for (HistoryReference historyReference : this.pastHistoryList) {
            if (historyReference.getHistoryType() != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasJustHistoryType(int n) {
        if (this.historyReference == null) {
            return false;
        }
        if (this.historyReference.getHistoryType() != n) {
            return false;
        }
        for (HistoryReference historyReference : this.pastHistoryList) {
            if (historyReference.getHistoryType() == n) continue;
            return false;
        }
        return true;
    }

    public boolean isIncludedInScope() {
        return this.isIncludedInScope;
    }

    public void setIncludedInScope(boolean bl, boolean bl2) {
        this.isIncludedInScope = bl;
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
        if (this.getChildCount() > 0 && bl2) {
            SiteNode siteNode = (SiteNode)this.getFirstChild();
            while (siteNode != null) {
                siteNode.setIncludedInScope(bl, bl2);
                siteNode = (SiteNode)this.getChildAfter(siteNode);
            }
        }
    }

    public boolean isExcludedFromScope() {
        return this.isExcludedFromScope;
    }

    public void setExcludedFromScope(boolean bl, boolean bl2) {
        this.isExcludedFromScope = bl;
        if (bl) {
            this.isIncludedInScope = false;
        }
        if (this.siteMap != null) {
            this.siteMap.applyFilter(this);
        }
        this.nodeChanged();
        if (this.getChildCount() > 0 && bl2) {
            SiteNode siteNode = (SiteNode)this.getFirstChild();
            while (siteNode != null) {
                siteNode.setExcludedFromScope(bl, bl2);
                siteNode = (SiteNode)this.getChildAfter(siteNode);
            }
        }
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        if (mutableTreeNode == this) {
            return;
        }
        super.setParent(mutableTreeNode);
    }

    @Override
    public SiteNode getParent() {
        return (SiteNode)super.getParent();
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    protected void setFiltered(boolean bl) {
        this.filtered = bl;
    }

    public boolean isDataDriven() {
        return this.dataDriven;
    }
}

