/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JMenu;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.view.messagecontainer.MessageContainer;
import org.zaproxy.zap.view.popup.ExtensionPopupMenuComponent;
import org.zaproxy.zap.view.popup.PopupMenuUtils;

public class ExtensionPopupMenu
extends JMenu
implements ExtensionPopupMenuComponent {
    private static final long serialVersionUID = 1925623776527543421L;
    private boolean orderChildren;

    public ExtensionPopupMenu() {
    }

    public ExtensionPopupMenu(String string) {
        super(string);
    }

    public void setOrderChildren(boolean bl) {
        this.orderChildren = bl;
    }

    public boolean isOrderChildren() {
        return this.orderChildren;
    }

    @Override
    public boolean isEnableForComponent(Component component) {
        return this.processExtensionPopupChildren(PopupMenuUtils.getPopupMenuInvokerWrapper(component));
    }

    protected boolean processExtensionPopupChildren(PopupMenuUtils.PopupMenuInvokerWrapper popupMenuInvokerWrapper) {
        if (this.isOrderChildren()) {
            Object object;
            int n;
            PopupMenuUtils.removeAllSeparators(this);
            ArrayList<ExtensionPopupMenuComponent> arrayList = new ArrayList<ExtensionPopupMenuComponent>();
            for (n = 0; n < this.getMenuComponentCount(); ++n) {
                ExtensionPopupMenuComponent extensionPopupMenuComponent;
                object = this.getMenuComponent(n);
                if (!PopupMenuUtils.isExtensionPopupMenuComponent((Component)object) || (extensionPopupMenuComponent = (ExtensionPopupMenuComponent)object).getMenuIndex() < 0) continue;
                arrayList.add(extensionPopupMenuComponent);
                this.remove(n);
                --n;
            }
            Collections.sort(arrayList, new Comparator<ExtensionPopupMenuComponent>(){

                @Override
                public int compare(ExtensionPopupMenuComponent extensionPopupMenuComponent, ExtensionPopupMenuComponent extensionPopupMenuComponent2) {
                    if (extensionPopupMenuComponent.getMenuIndex() > extensionPopupMenuComponent2.getMenuIndex()) {
                        return 1;
                    }
                    if (extensionPopupMenuComponent.getMenuIndex() < extensionPopupMenuComponent2.getMenuIndex()) {
                        return -1;
                    }
                    return 0;
                }
            });
            for (n = 0; n < arrayList.size(); ++n) {
                object = (ExtensionPopupMenuComponent)arrayList.get(n);
                int n2 = Math.max(object.getMenuIndex(), n);
                if (n2 >= this.getMenuComponentCount()) {
                    this.add((Component)object);
                    continue;
                }
                this.getPopupMenu().insert((Component)object, n2);
            }
        }
        boolean bl = false;
        Control.Mode mode = Control.getSingleton().getMode();
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            Component component = this.getMenuComponent(i);
            if (!PopupMenuUtils.isExtensionPopupMenuComponent(component)) continue;
            ExtensionPopupMenuComponent extensionPopupMenuComponent = (ExtensionPopupMenuComponent)((Object)component);
            boolean bl2 = popupMenuInvokerWrapper.isEnable(extensionPopupMenuComponent);
            if (bl2 && !extensionPopupMenuComponent.isSafe() && mode.equals((Object)Control.Mode.safe)) {
                component.setEnabled(false);
                continue;
            }
            if (bl2) {
                bl = true;
                if (extensionPopupMenuComponent.precedeWithSeparator() && PopupMenuUtils.insertSeparatorIfNeeded(this, i)) {
                    ++i;
                }
            }
            component.setVisible(bl2);
            if (!bl2 || !extensionPopupMenuComponent.succeedWithSeparator() || !PopupMenuUtils.insertSeparatorIfNeeded(this, i + 1)) continue;
            ++i;
        }
        PopupMenuUtils.removeTopAndBottomSeparators(this);
        return bl;
    }

    @Override
    public boolean isEnableForMessageContainer(MessageContainer<?> messageContainer) {
        return this.isEnableForComponent(messageContainer.getComponent());
    }

    public String getParentMenuName() {
        return null;
    }

    @Override
    public int getMenuIndex() {
        return -1;
    }

    public int getParentMenuIndex() {
        return -1;
    }

    public boolean isSubMenu() {
        return false;
    }

    @Override
    public boolean precedeWithSeparator() {
        return false;
    }

    @Override
    public boolean succeedWithSeparator() {
        return false;
    }

    @Override
    public boolean isSafe() {
        return true;
    }

    @Override
    public void dismissed(ExtensionPopupMenuComponent extensionPopupMenuComponent) {
        for (int i = 0; i < this.getMenuComponentCount(); ++i) {
            Component component = this.getMenuComponent(i);
            if (!PopupMenuUtils.isExtensionPopupMenuComponent(component)) continue;
            ((ExtensionPopupMenuComponent)((Object)component)).dismissed(extensionPopupMenuComponent);
        }
    }

    @Deprecated
    public void prepareShow() {
    }
}

