/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.help;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.SwingHelpUtilities;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.ExtensionFactory;
import org.zaproxy.zap.extension.AddOnInstallationStatusListener;
import org.zaproxy.zap.extension.help.BasicOnlineContentViewerUI;
import org.zaproxy.zap.extension.help.ZapBasicSearchNavigatorUI;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionHelp
extends ExtensionAdaptor {
    private static final String HELP_SET_PROPERTY = "HelpSet";
    private static final String HELP_ID_PROPERTY = "HelpID";
    private static final String HELP_SET_FILE_NAME = "helpset";
    public static final ImageIcon HELP_ICON = DisplayUtils.getScaledIcon(new ImageIcon(ExtensionHelp.class.getResource("/resource/icon/16/201.png")));
    private ZapMenuItem menuHelpZap = null;
    private JButton helpButton = null;
    private static HelpSet hs = null;
    private static HelpBroker hb = null;
    private static ActionListener showHelpActionListener;
    private static WeakHashMap<JComponent, String> componentsWithHelp;
    private static final Logger logger;

    public ExtensionHelp() {
        this.initialize();
    }

    public ExtensionHelp(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionHelp");
        this.setOrder(10000);
    }

    @Override
    public void initView(ViewDelegate viewDelegate) {
        super.initView(viewDelegate);
        SwingHelpUtilities.setContentViewerUI((String)BasicOnlineContentViewerUI.class.getCanonicalName());
        UIManager.getDefaults().put("ZapHelpSearchNavigatorUI", ZapBasicSearchNavigatorUI.class.getCanonicalName());
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addHelpMenuItem(this.getMenuHelpZapUserGuide());
            View.getSingleton().addMainToolbarSeparator();
            View.getSingleton().addMainToolbarButton(this.getHelpButton());
            ExtensionHelp.enableHelpKey(this.getView().getSiteTreePanel(), "ui.tabs.sites");
            ExtensionHelp.enableHelpKey(this.getView().getRequestPanel(), "ui.tabs.request");
            ExtensionHelp.enableHelpKey(this.getView().getResponsePanel(), "ui.tabs.response");
            this.setHelpEnabled(ExtensionHelp.getHelpBroker() != null);
            extensionHook.addAddOnInstallationStatusListener(new AddOnInstallationStatusListenerImpl());
        }
    }

    public boolean isHelpAvailable() {
        return hb != null;
    }

    private void setHelpEnabled(boolean bl) {
        if (this.getView() == null) {
            return;
        }
        JRootPane jRootPane = this.getView().getMainFrame().getRootPane();
        if (bl && ExtensionHelp.findHelpSetUrl() != null) {
            ExtensionHelp.createHelpBroker();
            this.getMenuHelpZapUserGuide().addActionListener(showHelpActionListener);
            this.getMenuHelpZapUserGuide().setToolTipText(null);
            this.getMenuHelpZapUserGuide().setEnabled(true);
            hb.enableHelpKey((Component)jRootPane, "zap.intro", hs, "javax.help.SecondaryWindow", null);
            for (Map.Entry<JComponent, String> entry : componentsWithHelp.entrySet()) {
                hb.enableHelp((Component)entry.getKey(), entry.getValue(), hs);
            }
            this.getHelpButton().setToolTipText(Constant.messages.getString("help.button.tooltip"));
            this.getHelpButton().setEnabled(true);
        } else {
            String string = Constant.messages.getString("help.error.nohelp");
            this.getMenuHelpZapUserGuide().setEnabled(false);
            this.getMenuHelpZapUserGuide().setToolTipText(string);
            this.getMenuHelpZapUserGuide().removeActionListener(showHelpActionListener);
            jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(156, 0));
            jRootPane.unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0));
            this.removeHelpProperties(jRootPane);
            for (JComponent jComponent : componentsWithHelp.keySet()) {
                this.removeHelpProperties(jComponent);
            }
            this.getHelpButton().setEnabled(false);
            this.getHelpButton().setToolTipText(string);
            hb = null;
            hs = null;
            showHelpActionListener = null;
        }
    }

    private void removeHelpProperties(JComponent jComponent) {
        jComponent.putClientProperty(HELP_ID_PROPERTY, null);
        jComponent.putClientProperty(HELP_SET_PROPERTY, null);
    }

    public static HelpBroker getHelpBroker() {
        if (hb == null) {
            ExtensionHelp.createHelpBroker();
        }
        return hb;
    }

    private static synchronized void createHelpBroker() {
        if (hb == null) {
            try {
                URL uRL = ExtensionHelp.findHelpSetUrl();
                if (uRL != null) {
                    hs = new HelpSet((ClassLoader)ExtensionFactory.getAddOnLoader(), uRL);
                    hb = hs.createHelpBroker();
                    showHelpActionListener = new CSH.DisplayHelpFromFocus(hb);
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    private static URL findHelpSetUrl() {
        return HelpSet.findHelpSet((ClassLoader)ExtensionFactory.getAddOnLoader(), (String)HELP_SET_FILE_NAME, (Locale)Constant.getLocale());
    }

    public static void enableHelpKey(Component component, String string) {
        if (component instanceof JComponent) {
            JComponent jComponent = (JComponent)component;
            if (componentsWithHelp == null) {
                componentsWithHelp = new WeakHashMap();
            }
            componentsWithHelp.put(jComponent, string);
        }
        if (hb != null) {
            hb.enableHelp(component, string, hs);
        }
    }

    public static void showHelp() {
        ExtensionHelp.showHelp("zap.intro");
    }

    public static void showHelp(String string) {
        if (ExtensionHelp.getHelpBroker() == null) {
            return;
        }
        try {
            ExtensionHelp.getHelpBroker().showID(string, "javax.help.SecondaryWindow", null);
        }
        catch (Exception exception) {
            logger.error((Object)("error loading help with index: " + string), (Throwable)exception);
        }
    }

    private ZapMenuItem getMenuHelpZapUserGuide() {
        if (this.menuHelpZap == null) {
            this.menuHelpZap = new ZapMenuItem("help.menu.guide", KeyStroke.getKeyStroke(112, 0, false));
        }
        return this.menuHelpZap;
    }

    private JButton getHelpButton() {
        if (this.helpButton == null) {
            this.helpButton = new JButton();
            this.helpButton.setIcon(new ImageIcon(ExtensionHelp.class.getResource("/resource/icon/16/201.png")));
            this.helpButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionHelp.showHelp();
                }
            });
        }
        return this.helpButton;
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("help.desc");
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }

    static {
        logger = Logger.getLogger(ExtensionHelp.class);
    }

    private class AddOnInstallationStatusListenerImpl
    implements AddOnInstallationStatusListener {
        private AddOnInstallationStatusListenerImpl() {
        }

        @Override
        public void addOnInstalled(AddOn addOn) {
            if (hb == null && ExtensionHelp.findHelpSetUrl() != null) {
                ExtensionHelp.this.setHelpEnabled(true);
            }
        }

        @Override
        public void addOnSoftUninstalled(AddOn addOn, boolean bl) {
            this.addOnUninstalled(addOn, bl);
        }

        @Override
        public void addOnUninstalled(AddOn addOn, boolean bl) {
            if (hb != null && ExtensionHelp.findHelpSetUrl() == null) {
                ExtensionHelp.this.setHelpEnabled(false);
            }
        }
    }
}

