/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.history;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;

public class ManageTagsDialog
extends AbstractDialog {
    private static final long serialVersionUID = 1L;
    private static final int panelWidth = 250;
    private static final int panelHeight = 300;
    private JPanel jPanel = null;
    private JComboBox<String> txtTagAdd = null;
    private JButton btnAdd = null;
    private JButton btnDelete = null;
    private JButton btnSave = null;
    private JButton btnCancel = null;
    private JList<String> tagList = null;
    private DefaultListModel<String> tagListModel = null;
    private ExtensionHistory extension = null;
    private HistoryReference historyRef;
    private JScrollPane jScrollPane = null;
    private DefaultComboBoxModel<String> tagAddModel = null;
    private Vector<String> addedTags = new Vector();
    private Vector<String> deletedTags = new Vector();

    public ManageTagsDialog() throws HeadlessException {
        this.initialize();
    }

    public ManageTagsDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.initialize();
    }

    private void initialize() {
        this.setTitle(Constant.messages.getString("history.managetags.title"));
        this.setContentPane(this.getJPanel());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(250, 300);
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }
        });
        this.pack();
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setPreferredSize(new Dimension(250, 300));
            this.jPanel.setMinimumSize(new Dimension(250, 300));
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints3.anchor = 13;
            gridBagConstraints4.gridy = 2;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints5.gridy = 3;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 18;
            gridBagConstraints5.ipadx = 0;
            gridBagConstraints5.ipady = 10;
            gridBagConstraints6.gridy = 3;
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.anchor = 12;
            gridBagConstraints7.gridy = 4;
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints7.anchor = 13;
            gridBagConstraints8.gridy = 4;
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints8.anchor = 13;
            this.jPanel.add((Component)new JLabel(Constant.messages.getString("history.managetags.label.addtag")), gridBagConstraints);
            this.jPanel.add(this.getTxtTagAdd(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnAdd(), gridBagConstraints3);
            this.jPanel.add((Component)new JLabel(Constant.messages.getString("history.managetags.label.currenttags")), gridBagConstraints4);
            this.jPanel.add((Component)this.getJScrollPane(), gridBagConstraints5);
            this.jPanel.add((Component)this.getBtnDelete(), gridBagConstraints6);
            this.jPanel.add((Component)this.getBtnCancel(), gridBagConstraints7);
            this.jPanel.add((Component)this.getBtnSave(), gridBagConstraints8);
        }
        return this.jPanel;
    }

    private JList<String> getTagList() {
        if (this.tagList == null) {
            this.tagList = new JList();
            this.tagList.setLayoutOrientation(0);
            this.tagList.setSelectionMode(2);
            this.tagListModel = new DefaultListModel();
            this.tagList.setModel(this.tagListModel);
        }
        return this.tagList;
    }

    public void setTags(List<String> list) {
        this.addedTags.clear();
        this.deletedTags.clear();
        this.tagListModel.clear();
        for (String string : list) {
            this.tagListModel.addElement(string);
            this.getAllTagsModel().removeElement(string);
        }
    }

    private void save() {
        for (String string : this.addedTags) {
            this.historyRef.addTag(string);
        }
        for (String string : this.deletedTags) {
            this.historyRef.deleteTag(string);
        }
        this.extension.notifyHistoryItemChanged(this.historyRef);
    }

    private void addTag(String string) {
        if (string != null && string.length() > 0 && !this.tagListModel.contains(string)) {
            this.tagListModel.addElement(string);
            if (this.deletedTags.contains(string)) {
                this.deletedTags.remove(string);
            } else {
                this.addedTags.add(string);
            }
            this.getAllTagsModel().removeElement(string);
        }
    }

    private void deleteTags(List<String> list) {
        for (String string : list) {
            this.tagListModel.removeElement(string);
            if (this.addedTags.contains(string)) {
                this.addedTags.remove(string);
            } else {
                this.deletedTags.add(string.toString());
            }
            this.getAllTagsModel().addElement(string);
        }
    }

    private JComboBox<String> getTxtTagAdd() {
        if (this.txtTagAdd == null) {
            this.txtTagAdd = new JComboBox();
            this.txtTagAdd.setEditable(true);
            this.tagAddModel = this.getAllTagsModel();
            this.txtTagAdd.setModel(this.tagAddModel);
        }
        return this.txtTagAdd;
    }

    private DefaultComboBoxModel<String> getAllTagsModel() {
        if (this.tagAddModel == null) {
            this.tagAddModel = new DefaultComboBoxModel();
        }
        return this.tagAddModel;
    }

    private JButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new JButton();
            this.btnAdd.setText(Constant.messages.getString("history.managetags.button.add"));
            this.btnAdd.setMinimumSize(new Dimension(75, 30));
            this.btnAdd.setPreferredSize(new Dimension(75, 30));
            this.btnAdd.setMaximumSize(new Dimension(100, 40));
            this.btnAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageTagsDialog.this.addTag(ManageTagsDialog.this.getTxtTagAdd().getSelectedItem().toString());
                    ManageTagsDialog.this.getTxtTagAdd().setSelectedIndex(0);
                }
            });
        }
        return this.btnAdd;
    }

    private JButton getBtnDelete() {
        if (this.btnDelete == null) {
            this.btnDelete = new JButton();
            this.btnDelete.setText(Constant.messages.getString("history.managetags.button.delete"));
            this.btnDelete.setMinimumSize(new Dimension(75, 30));
            this.btnDelete.setPreferredSize(new Dimension(75, 30));
            this.btnDelete.setMaximumSize(new Dimension(100, 40));
            this.btnDelete.setEnabled(true);
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageTagsDialog.this.deleteTags(ManageTagsDialog.this.tagList.getSelectedValuesList());
                }
            });
        }
        return this.btnDelete;
    }

    private JButton getBtnSave() {
        if (this.btnSave == null) {
            this.btnSave = new JButton();
            this.btnSave.setText(Constant.messages.getString("history.managetags.button.save"));
            this.btnSave.setMinimumSize(new Dimension(75, 30));
            this.btnSave.setPreferredSize(new Dimension(75, 30));
            this.btnSave.setMaximumSize(new Dimension(100, 40));
            this.btnSave.setEnabled(true);
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageTagsDialog.this.save();
                    ManageTagsDialog.this.extension.hideManageTagsDialog();
                }
            });
        }
        return this.btnSave;
    }

    private JButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new JButton();
            this.btnCancel.setText(Constant.messages.getString("all.button.cancel"));
            this.btnCancel.setMinimumSize(new Dimension(75, 30));
            this.btnCancel.setPreferredSize(new Dimension(75, 30));
            this.btnCancel.setMaximumSize(new Dimension(100, 40));
            this.btnCancel.setEnabled(true);
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ManageTagsDialog.this.extension.hideManageTagsDialog();
                }
            });
        }
        return this.btnCancel;
    }

    public void setPlugin(ExtensionHistory extensionHistory) {
        this.extension = extensionHistory;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setHorizontalScrollBarPolicy(31);
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setViewportView(this.getTagList());
        }
        return this.jScrollPane;
    }

    public HistoryReference getHistoryRef() {
        return this.historyRef;
    }

    public void setHistoryRef(HistoryReference historyReference) {
        this.historyRef = historyReference;
    }

    public void setAllTags(List<String> list) {
        this.getAllTagsModel().removeAllElements();
        this.getAllTagsModel().addElement("");
        for (String string : list) {
            this.getAllTagsModel().addElement(string);
        }
    }
}

