/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.keyboard;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.keyboard.KeyboardMapping;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcut;
import org.zaproxy.zap.extension.keyboard.KeyboardShortcutTableModel;
import org.zaproxy.zap.view.StandardFieldsDialog;

public class DialogEditShortcut
extends StandardFieldsDialog {
    private static final String FIELD_ACTION = "keyboard.dialog.label.action";
    private static final String FIELD_KEY = "keyboard.dialog.label.key";
    private static final String FIELD_CONTROL = "keyboard.dialog.label.control";
    private static final String FIELD_ALT = "keyboard.dialog.label.alt";
    private static final String FIELD_SHIFT = "keyboard.dialog.label.shift";
    private static final String FIELD_INFO = "keyboard.dialog.label.info";
    private static final long serialVersionUID = 1L;
    private KeyboardShortcut shortcut;
    private KeyboardShortcutTableModel model;

    public DialogEditShortcut(Window window) {
        super(window, "keyboard.dialog.title", new Dimension(300, 200), true);
    }

    public DialogEditShortcut(Frame frame) {
        super(frame, "keyboard.dialog.title", new Dimension(300, 200));
    }

    public void init(KeyboardShortcut keyboardShortcut, KeyboardShortcutTableModel keyboardShortcutTableModel) {
        this.shortcut = keyboardShortcut;
        this.model = keyboardShortcutTableModel;
        this.removeAllFields();
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DialogEditShortcut.this.checkDuplicate();
            }
        };
        this.addReadOnlyField(FIELD_ACTION, keyboardShortcut.getName(), false);
        this.addComboField(FIELD_KEY, this.getKeyList(), this.getKey(keyboardShortcut.getKeyStroke()));
        this.addFieldListener(FIELD_KEY, actionListener);
        this.addCheckBoxField(FIELD_CONTROL, this.isModifier(keyboardShortcut.getKeyStroke(), 128));
        this.addFieldListener(FIELD_CONTROL, actionListener);
        this.addCheckBoxField(FIELD_ALT, this.isModifier(keyboardShortcut.getKeyStroke(), 512));
        this.addFieldListener(FIELD_ALT, actionListener);
        this.addCheckBoxField(FIELD_SHIFT, this.isModifier(keyboardShortcut.getKeyStroke(), 64));
        this.addFieldListener(FIELD_SHIFT, actionListener);
        this.addReadOnlyField(FIELD_INFO, "", true);
        this.getField(FIELD_INFO).setForeground(Color.RED);
    }

    @Override
    public String getSaveButtonText() {
        return Constant.messages.getString("keyboard.dialog.button.save");
    }

    private void checkDuplicate() {
        KeyboardShortcut keyboardShortcut = this.getDuplicate();
        if (keyboardShortcut != null) {
            this.setFieldValue(FIELD_INFO, MessageFormat.format(Constant.messages.getString("keyboard.dialog.warning.dup"), keyboardShortcut.getName()));
        } else {
            this.setFieldValue(FIELD_INFO, "");
        }
    }

    private KeyboardShortcut getDuplicate() {
        KeyStroke keyStroke = this.getKeyStroke();
        if (keyStroke != null) {
            for (KeyboardShortcut keyboardShortcut : this.model.getElements()) {
                KeyStroke keyStroke2;
                if (keyboardShortcut.equals(this.shortcut) || (keyStroke2 = keyboardShortcut.getKeyStroke()) == null || keyStroke.getKeyCode() != keyStroke2.getKeyCode() || keyStroke.getModifiers() != keyStroke2.getModifiers()) continue;
                return keyboardShortcut;
            }
        }
        return null;
    }

    private List<String> getKeyList() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        for (n = 65; n <= 90; n = (char)(n + '\u0001')) {
            arrayList.add(String.valueOf((char)n));
        }
        for (n = 0; n <= 9; ++n) {
            arrayList.add(String.valueOf(n));
        }
        arrayList.add("-");
        arrayList.add("=");
        arrayList.add("[");
        arrayList.add("]");
        arrayList.add(";");
        arrayList.add("'");
        arrayList.add("#");
        arrayList.add(",");
        arrayList.add(".");
        arrayList.add("/");
        for (n = 1; n <= 12; ++n) {
            arrayList.add("F" + n);
        }
        arrayList.add(Constant.messages.getString("keyboard.key.up"));
        arrayList.add(Constant.messages.getString("keyboard.key.down"));
        arrayList.add(Constant.messages.getString("keyboard.key.left"));
        arrayList.add(Constant.messages.getString("keyboard.key.right"));
        return arrayList;
    }

    private String getKey(KeyStroke keyStroke) {
        if (keyStroke != null) {
            return KeyboardMapping.keyString(keyStroke.getKeyCode());
        }
        return "";
    }

    private char selectedKey() {
        return KeyboardMapping.keyCode(this.getStringValue(FIELD_KEY));
    }

    private boolean isModifier(KeyStroke keyStroke, int n) {
        if (keyStroke != null) {
            return (keyStroke.getModifiers() & n) != 0;
        }
        return false;
    }

    public KeyStroke getKeyStroke() {
        KeyStroke keyStroke = null;
        char c = this.selectedKey();
        int n = 0;
        if (c != '\u0000') {
            if (this.getBoolValue(FIELD_CONTROL).booleanValue()) {
                n |= 0x80;
            }
            if (this.getBoolValue(FIELD_ALT).booleanValue()) {
                n |= 0x200;
            }
            if (this.getBoolValue(FIELD_SHIFT).booleanValue()) {
                n |= 0x40;
            }
            keyStroke = KeyStroke.getKeyStroke(c, n, false);
        }
        return keyStroke;
    }

    @Override
    public void save() {
        KeyboardShortcut keyboardShortcut = this.getDuplicate();
        if (keyboardShortcut != null) {
            keyboardShortcut.setKeyStroke(null);
        }
        KeyStroke keyStroke = this.getKeyStroke();
        this.shortcut.setKeyStroke(keyStroke);
    }

    @Override
    public String validateFields() {
        return null;
    }
}

