/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.script;

import javax.swing.tree.DefaultMutableTreeNode;
import org.parosproxy.paros.Constant;
import org.zaproxy.zap.extension.script.ScriptType;
import org.zaproxy.zap.extension.script.ScriptWrapper;

public class ScriptNode
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = 1L;
    private String nodeName = null;
    private ScriptType type = null;
    private boolean template = false;

    public ScriptNode() {
        this.nodeName = Constant.messages.getString("script.tree.root");
    }

    public ScriptNode(boolean bl) {
        this.template = bl;
        this.nodeName = bl ? Constant.messages.getString("script.tree.templates") : Constant.messages.getString("script.tree.scripts");
    }

    public ScriptNode(ScriptType scriptType, boolean bl) {
        this.nodeName = Constant.messages.getString(scriptType.getI18nKey());
        this.type = scriptType;
        this.template = bl;
    }

    public ScriptNode(String string) {
        this.nodeName = string;
    }

    public ScriptNode(ScriptWrapper scriptWrapper) {
        this(scriptWrapper, false);
    }

    public ScriptNode(ScriptWrapper scriptWrapper, boolean bl) {
        this.nodeName = scriptWrapper.getName();
        this.type = scriptWrapper.getType();
        this.template = bl;
        this.setUserObject(scriptWrapper);
    }

    @Override
    public String toString() {
        return this.nodeName;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String string) {
        this.nodeName = string;
    }

    @Override
    public ScriptNode getParent() {
        return (ScriptNode)super.getParent();
    }

    public ScriptType getType() {
        return this.type;
    }

    public boolean isTemplate() {
        return this.template;
    }
}

