/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.search;

import org.apache.commons.configuration.ConversionException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;

public class SearchParam
extends AbstractParam {
    private static final Logger LOGGER = Logger.getLogger(SearchParam.class);
    private static final String PARAM_BASE_KEY = "search";
    private static final String PARAM_MAXIMUM_RESULTS_GUI = "search.maxResultsGUI";
    private static final int DEFAULT_MAXIMUM_RESULTS_GUI = 5000;
    private int maximumSearchResultsGUI = 5000;

    @Override
    protected void parse() {
        try {
            this.maximumSearchResultsGUI = this.getConfig().getInt(PARAM_MAXIMUM_RESULTS_GUI, 5000);
        }
        catch (ConversionException conversionException) {
            LOGGER.error((Object)("Failed to load the \"Maximum search results in GUI\" configuration: " + conversionException.getMessage()), (Throwable)conversionException);
            this.maximumSearchResultsGUI = 5000;
        }
    }

    public void setMaximumSearchResultsGUI(int n) {
        if (this.maximumSearchResultsGUI != n) {
            this.maximumSearchResultsGUI = n;
            this.getConfig().setProperty(PARAM_MAXIMUM_RESULTS_GUI, (Object)n);
        }
    }

    public int getMaximumSearchResultsGUI() {
        return this.maximumSearchResultsGUI;
    }
}

