/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.mac;

import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.SystemClipboard;
import com.sun.glass.ui.mac.MacPasteboard;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MacSystemClipboard
extends SystemClipboard {
    static final String FILE_SCHEME = "file";
    private static final String BAD_URI_MSG = "bad URI in com.sun.glass.ui.mac.MacSystemClipboard for file: ";
    private static final String BAD_URL_MSG = "bad URL in com.sun.glass.ui.mac.MacSystemClipboard for file: ";
    static final boolean SUPPORT_10_5_API = true;
    static final boolean SUPPORT_10_5_API_FORCE = false;
    static final boolean SUPPORT_10_6_API = false;
    long seed = 0L;
    final MacPasteboard pasteboard;
    private static HashMap utm = null;
    private static HashMap mtu = null;

    public MacSystemClipboard(String name) {
        super(name);
        this.pasteboard = name.equals("DND") ? new MacPasteboard(2) : (name.equals("SYSTEM") ? new MacPasteboard(1) : new MacPasteboard(name));
    }

    @Override
    protected boolean isOwner() {
        return this.seed == this.pasteboard.getSeed();
    }

    @Override
    protected int supportedSourceActionsFromSystem() {
        return this.pasteboard.getAllowedOperation();
    }

    @Override
    protected void pushTargetActionToSystem(int actionDone) {
    }

    @Override
    protected void pushToSystem(HashMap<String, Object> data, int supportedActions) {
        HashMap<String, Pixels> itemFirst = null;
        HashMap[] itemList = null;
        Set<String> keys = data.keySet();
        for (String mime : keys) {
            Object object = data.get(mime);
            if (object == null) continue;
            if (mime.equals("text/uri-list")) {
                int i;
                String list = (String)object;
                String[] split = list.split("\n");
                int count = 0;
                for (i = 0; i < split.length; ++i) {
                    String string = split[i];
                    if (string.startsWith("#")) continue;
                    ++count;
                }
                if (count <= 0) continue;
                itemList = new HashMap[count];
                count = 0;
                for (i = 0; i < split.length; ++i) {
                    String file = split[i];
                    if (file.startsWith("#")) continue;
                    URI uri = this.createUri(file, BAD_URI_MSG);
                    String utf = "public.url";
                    if (uri.getScheme() == null) {
                        utf = "public.file-url";
                        uri = this.createUri(FILE_SCHEME, uri.getPath(), BAD_URI_MSG);
                    }
                    itemList[count] = new HashMap();
                    itemList[count].put(utf, uri.toASCIIString());
                    ++count;
                }
                continue;
            }
            if (mime.equals("application/x-java-rawimage")) {
                Pixels pixels = (Pixels)object;
                if (itemFirst == null) {
                    itemFirst = new HashMap<String, Pixels>();
                }
                itemFirst.put(this.mimeToUtf(mime), pixels);
                continue;
            }
            if (mime.equals("text/plain") || mime.equals("text/html") || mime.equals("text/rtf")) {
                if (object instanceof String) {
                    String string = (String)object;
                    if (itemFirst == null) {
                        itemFirst = new HashMap();
                    }
                    itemFirst.put(this.mimeToUtf(mime), (Pixels)((Object)string));
                    continue;
                }
                System.err.println("DelayedCallback not implemented yet: RT-14593");
                Thread.dumpStack();
                continue;
            }
            if (mime.equals("application/x-java-file-list")) {
                String[] files = (String[])object;
                if (data.get("text/uri-list") == null) {
                    itemList = new HashMap[files.length];
                    for (int i = 0; i < files.length; ++i) {
                        String file = files[i];
                        URI uri = this.createUri(file, BAD_URI_MSG);
                        String utf = "public.url";
                        if (uri.getScheme() == null) {
                            utf = "public.file-url";
                            uri = this.createUri(FILE_SCHEME, uri.getPath(), BAD_URI_MSG);
                        }
                        itemList[i] = new HashMap();
                        itemList[i].put(utf, uri.toASCIIString());
                    }
                    continue;
                }
                if (itemFirst == null) {
                    itemFirst = new HashMap();
                }
                StringBuilder string = null;
                for (int i = 0; i < files.length; ++i) {
                    String file = files[i];
                    URI uri = this.createUri(file, BAD_URI_MSG);
                    if (string == null) {
                        string = new StringBuilder();
                    }
                    string.append(uri.getPath());
                    if (i >= files.length - 1) continue;
                    string.append("\n");
                }
                if (string == null || itemFirst.get("public.utf8-plain-text") != null) continue;
                itemFirst.remove("public.utf8-plain-text");
                itemFirst.put("public.utf8-plain-text", (Pixels)((Object)string.toString()));
                continue;
            }
            if (itemFirst == null) {
                itemFirst = new HashMap();
            }
            itemFirst.put(this.mimeToUtf(mime), (Pixels)this.serialize(object));
        }
        if (itemFirst != null) {
            if (itemList == null) {
                itemList = new HashMap[]{itemFirst};
            } else {
                HashMap temp = itemList[0];
                itemList[0] = itemFirst;
                for (String utf : temp.keySet()) {
                    Object object = temp.get(utf);
                    itemList[0].put(utf, object);
                }
            }
        }
        if (itemList != null) {
            this.seed = this.pasteboard.putItems(itemList, supportedActions);
        }
    }

    @Override
    protected Object popFromSystem(String mime) {
        Object object = null;
        String[][] utfs = this.pasteboard.getUTFs();
        if (mime.equals("text/uri-list")) {
            if (utfs != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < utfs.length; ++i) {
                    String url = this.pasteboard.getItemStringForUTF(i, this.mimeToUtf("text/uri-list"));
                    if (url == null) continue;
                    list.add(url);
                    break;
                }
                if (list.size() > 0) {
                    object = list.get(0);
                }
            }
        } else if (mime.equals("application/x-java-rawimage")) {
            if (utfs != null) {
                ArrayList<Pixels> list = new ArrayList<Pixels>();
                for (int i = 0; i < utfs.length; ++i) {
                    byte[] data = this.pasteboard.getItemAsRawImage(i);
                    if (data == null) continue;
                    Pixels pixels = this.getPixelsForRawImage(data);
                    list.add(pixels);
                    break;
                }
                if (list.size() > 0) {
                    object = list.get(0);
                }
            }
        } else if (mime.equals("text/plain") || mime.equals("text/html") || mime.equals("text/rtf")) {
            if (utfs != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < utfs.length; ++i) {
                    String item = this.pasteboard.getItemStringForUTF(i, this.mimeToUtf(mime));
                    if (item == null) continue;
                    list.add(item);
                    break;
                }
                if (list.size() > 0) {
                    object = list.get(0);
                }
            }
        } else if (mime.equals("application/x-java-file-list")) {
            if (utfs != null) {
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < utfs.length; ++i) {
                    String file = this.pasteboard.getItemStringForUTF(i, "public.file-url");
                    if (file == null) continue;
                    URL url = this.createUrl(file, BAD_URL_MSG);
                    list.add(url.getPath());
                }
                if (list.size() > 0) {
                    object = new String[list.size()];
                    list.toArray((T[])object);
                }
            }
        } else if (utfs != null) {
            ArrayList<ByteBuffer> list = new ArrayList<ByteBuffer>();
            for (int i = 0; i < utfs.length; ++i) {
                byte[] data = this.pasteboard.getItemBytesForUTF(i, this.mimeToUtf(mime));
                if (data == null) continue;
                ByteBuffer bb = ByteBuffer.wrap(data);
                list.add(bb);
                break;
            }
            if (list.size() > 0) {
                object = list.get(0);
            }
        }
        return object;
    }

    @Override
    protected String[] mimesFromSystem() {
        String[][] all = this.pasteboard.getUTFs();
        ArrayList<String> mimes = new ArrayList<String>();
        if (all != null) {
            for (int i = 0; i < all.length; ++i) {
                String[] utfs = all[i];
                if (utfs == null) continue;
                for (int j = 0; j < utfs.length; ++j) {
                    String utf = utfs[j];
                    String mime = this.utfToMime(utf);
                    if (mime == null || mimes.contains(mime)) continue;
                    mimes.add(mime);
                }
            }
        }
        String[] strings = new String[mimes.size()];
        mimes.toArray(strings);
        return strings;
    }

    @Override
    public String toString() {
        return "Mac OS X " + this.pasteboard.getName() + " Clipboard";
    }

    private synchronized String utfToMime(String utf) {
        if (utm == null) {
            utm = new HashMap(6);
            utm.put("public.utf8-plain-text", "text/plain");
            utm.put("public.html", "text/html");
            utm.put("public.rtf", "text/rtf");
            utm.put("public.url", "text/uri-list");
            utm.put("public.file-url", "application/x-java-file-list");
            utm.put("public.tiff", "application/x-java-rawimage");
            utm.put("public.png", "application/x-java-rawimage");
        }
        if (utm.containsKey(utf)) {
            return (String)utm.get(utf);
        }
        return utf;
    }

    private synchronized String mimeToUtf(String mime) {
        if (mtu == null) {
            mtu = new HashMap(4);
            mtu.put("text/plain", "public.utf8-plain-text");
            mtu.put("text/html", "public.html");
            mtu.put("text/rtf", "public.rtf");
            mtu.put("text/uri-list", "public.url");
            mtu.put("application/x-java-file-list", "public.file-url");
        }
        if (mtu.containsKey(mime)) {
            return (String)mtu.get(mime);
        }
        return mime;
    }

    private URI createUri(String path, String message) {
        URI uri = null;
        try {
            uri = new URI(path);
        }
        catch (URISyntaxException ex) {
            System.err.println(message + path);
            Thread.dumpStack();
        }
        return uri;
    }

    private URI createUri(String scheme, String path, String message) {
        URI uri = null;
        try {
            uri = new URI(scheme, null, path, null);
        }
        catch (URISyntaxException ex) {
            System.err.println(message + path);
            Thread.dumpStack();
        }
        return uri;
    }

    private URL createUrl(String path, String message) {
        URL url = null;
        try {
            url = new URL(path);
        }
        catch (MalformedURLException ex) {
            System.err.println(message + path);
            Thread.dumpStack();
        }
        return url;
    }

    private byte[] serialize(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            return string.getBytes();
        }
        if (object instanceof ByteBuffer) {
            ByteBuffer buffer = (ByteBuffer)object;
            return buffer.array();
        }
        throw new RuntimeException("can not handle " + object);
    }
}

