/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.ps;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.CompositeMode;
import com.sun.prism.PixelFormat;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.camera.PrismCameraImpl;
import com.sun.prism.impl.BaseContext;
import com.sun.prism.impl.BaseGraphics;
import com.sun.prism.impl.VertexBuffer;
import com.sun.prism.impl.ps.BaseShaderGraphics;
import com.sun.prism.impl.ps.PaintHelper;
import com.sun.prism.paint.Color;
import com.sun.prism.paint.Gradient;
import com.sun.prism.paint.ImagePattern;
import com.sun.prism.paint.LinearGradient;
import com.sun.prism.paint.Paint;
import com.sun.prism.paint.RadialGradient;
import com.sun.prism.ps.Shader;
import com.sun.prism.ps.ShaderFactory;

public abstract class BaseShaderContext
extends BaseContext {
    private static final int NUM_STOCK_SHADER_SLOTS = MaskType.values().length << 4;
    private final Shader[] stockShaders = new Shader[NUM_STOCK_SHADER_SLOTS];
    private Shader textureRGBShader;
    private Shader textureMaskRGBShader;
    private Shader textureYV12Shader;
    private Shader textureFirstLCDShader;
    private Shader textureSecondLCDShader;
    private Shader externalShader;
    private RTTexture lcdBuffer;
    private final ShaderFactory factory;
    private State state;

    protected BaseShaderContext(Screen screen, ShaderFactory shaderFactory, VertexBuffer vertexBuffer) {
        super(screen, shaderFactory, vertexBuffer);
        this.factory = shaderFactory;
        this.init();
    }

    protected void init() {
        this.state = null;
        if (this.externalShader != null && !this.externalShader.isValid()) {
            this.externalShader.dispose();
            this.externalShader = null;
        }
    }

    protected void resetLastClip(State state) {
        state.lastClip = null;
    }

    protected abstract State updateRenderTarget(RenderTarget var1, PrismCameraImpl var2, boolean var3);

    protected abstract void updateTexture(int var1, Texture var2);

    protected abstract void updateShaderTransform(Shader var1, BaseTransform var2);

    protected abstract void updateClipRect(Rectangle var1);

    protected abstract void updateCompositeMode(CompositeMode var1);

    private static int getStockShaderIndex(MaskType maskType, Paint paint) {
        int n;
        int n2;
        if (paint == null) {
            n2 = 0;
            n = 0;
        } else {
            n2 = paint.getType().ordinal();
            n = paint.getType().isGradient() ? ((Gradient)paint).getSpreadMethod() : 0;
        }
        return maskType.ordinal() << 4 | n2 << 2 | n << 0;
    }

    private Shader getPaintShader(MaskType maskType, Paint paint) {
        int n = BaseShaderContext.getStockShaderIndex(maskType, paint);
        Shader shader = this.stockShaders[n];
        if (shader != null && !shader.isValid()) {
            shader.dispose();
            shader = null;
        }
        if (shader == null) {
            String string = maskType.getName() + "_" + paint.getType().getName();
            if (paint.getType().isGradient()) {
                Gradient gradient = (Gradient)paint;
                int n2 = gradient.getSpreadMethod();
                if (n2 == 0) {
                    string = string + "_PAD";
                } else if (n2 == 1) {
                    string = string + "_REFLECT";
                } else if (n2 == 2) {
                    string = string + "_REPEAT";
                }
            }
            shader = this.stockShaders[n] = this.factory.createStockShader(string);
        }
        return shader;
    }

    private void updatePaintShader(BaseShaderGraphics baseShaderGraphics, Shader shader, Paint paint, float f, float f2, float f3, float f4) {
        float f5;
        float f6;
        float f7;
        float f8;
        Paint.Type type = paint.getType();
        if (type == Paint.Type.COLOR) {
            return;
        }
        if (paint.isProportional()) {
            f8 = f;
            f7 = f2;
            f6 = f3;
            f5 = f4;
        } else {
            f8 = 0.0f;
            f7 = 0.0f;
            f6 = 1.0f;
            f5 = 1.0f;
        }
        switch (type) {
            case LINEAR_GRADIENT: {
                PaintHelper.setLinearGradient(baseShaderGraphics, shader, (LinearGradient)paint, f8, f7, f6, f5);
                break;
            }
            case RADIAL_GRADIENT: {
                PaintHelper.setRadialGradient(baseShaderGraphics, shader, (RadialGradient)paint, f8, f7, f6, f5);
                break;
            }
            case IMAGE_PATTERN: {
                PaintHelper.setImagePattern(baseShaderGraphics, shader, (ImagePattern)paint, f8, f7, f6, f5);
            }
        }
    }

    private Shader getTextureRGBShader() {
        if (this.textureRGBShader != null && !this.textureRGBShader.isValid()) {
            this.textureRGBShader.dispose();
            this.textureRGBShader = null;
        }
        if (this.textureRGBShader == null) {
            this.textureRGBShader = this.factory.createStockShader("Solid_TextureRGB");
        }
        return this.textureRGBShader;
    }

    private Shader getTextureMaskRGBShader() {
        if (this.textureMaskRGBShader != null && !this.textureMaskRGBShader.isValid()) {
            this.textureMaskRGBShader.dispose();
            this.textureMaskRGBShader = null;
        }
        if (this.textureMaskRGBShader == null) {
            this.textureMaskRGBShader = this.factory.createStockShader("Mask_TextureRGB");
        }
        return this.textureMaskRGBShader;
    }

    private Shader getTextureYV12Shader() {
        if (this.textureYV12Shader != null && !this.textureYV12Shader.isValid()) {
            this.textureYV12Shader.dispose();
            this.textureYV12Shader = null;
        }
        if (this.textureYV12Shader == null) {
            this.textureYV12Shader = this.factory.createStockShader("Solid_TextureYV12");
        }
        return this.textureYV12Shader;
    }

    private Shader getTextureFirstPassLCDShader() {
        if (this.textureFirstLCDShader != null && !this.textureFirstLCDShader.isValid()) {
            this.textureFirstLCDShader.dispose();
            this.textureFirstLCDShader = null;
        }
        if (this.textureFirstLCDShader == null) {
            this.textureFirstLCDShader = this.factory.createStockShader("Solid_TextureFirstPassLCD");
        }
        return this.textureFirstLCDShader;
    }

    private Shader getTextureSecondPassLCDShader() {
        if (this.textureSecondLCDShader != null && !this.textureSecondLCDShader.isValid()) {
            this.textureSecondLCDShader.dispose();
            this.textureSecondLCDShader = null;
        }
        if (this.textureSecondLCDShader == null) {
            this.textureSecondLCDShader = this.factory.createStockShader("Solid_TextureSecondPassLCD");
        }
        return this.textureSecondLCDShader;
    }

    private void updatePerVertexColor(Paint paint, float f) {
        if (paint != null && paint.getType() == Paint.Type.COLOR) {
            this.getVertexBuffer().setPerVertexColor((Color)paint, f);
        } else {
            this.getVertexBuffer().setPerVertexColor(f);
        }
    }

    @Override
    public void validatePaintOp(BaseGraphics baseGraphics, BaseTransform baseTransform, Texture texture, float f, float f2, float f3, float f4) {
        this.validatePaintOp((BaseShaderGraphics)baseGraphics, baseTransform, texture, f, f2, f3, f4);
    }

    Shader validatePaintOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, MaskType maskType, float f, float f2, float f3, float f4) {
        return this.validatePaintOp(baseShaderGraphics, baseTransform, maskType, null, f, f2, f3, f4);
    }

    Shader validatePaintOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, MaskType maskType, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        if (this.state.lastConst1 != f5 || this.state.lastConst2 != f6 || this.state.lastConst3 != f7 || this.state.lastConst4 != f8 || this.state.lastConst5 != f9 || this.state.lastConst6 != f10) {
            this.flushVertexBuffer();
            this.state.lastConst1 = f5;
            this.state.lastConst2 = f6;
            this.state.lastConst3 = f7;
            this.state.lastConst4 = f8;
            this.state.lastConst5 = f9;
            this.state.lastConst6 = f10;
        }
        return this.validatePaintOp(baseShaderGraphics, baseTransform, maskType, null, f, f2, f3, f4);
    }

    Shader validatePaintOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture texture, float f, float f2, float f3, float f4) {
        return this.validatePaintOp(baseShaderGraphics, baseTransform, MaskType.TEXTURE, texture, f, f2, f3, f4);
    }

    private Shader validatePaintOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, MaskType maskType, Texture texture, float f, float f2, float f3, float f4) {
        if (maskType == null) {
            throw new InternalError("maskType must be non-null");
        }
        if (this.externalShader == null) {
            Object object;
            Paint paint = baseShaderGraphics.getPaint();
            Texture texture2 = null;
            Texture texture3 = null;
            Texture texture4 = null;
            if (paint.getType().isGradient()) {
                this.flushVertexBuffer();
                texture2 = PaintHelper.getGradientTexture(baseShaderGraphics, (Gradient)paint);
            } else if (paint.getType() == Paint.Type.IMAGE_PATTERN) {
                object = (ImagePattern)paint;
                texture2 = baseShaderGraphics.getResourceFactory().getCachedTexture(((ImagePattern)object).getImage());
                texture2.setWrapMode(Texture.WrapMode.REPEAT);
            }
            if (texture != null) {
                texture3 = texture;
                texture4 = texture2;
            } else {
                texture3 = texture2;
                texture4 = null;
            }
            object = this.getPaintShader(maskType, paint);
            this.checkState(baseShaderGraphics, baseTransform, (Shader)object, texture3, texture4);
            this.updatePaintShader(baseShaderGraphics, (Shader)object, paint, f, f2, f3, f4);
            this.updatePerVertexColor(paint, baseShaderGraphics.getExtraAlpha());
            return object;
        }
        this.checkState(baseShaderGraphics, baseTransform, this.externalShader, texture, null);
        this.updatePerVertexColor(null, baseShaderGraphics.getExtraAlpha());
        return this.externalShader;
    }

    @Override
    public void validateTextureOp(BaseGraphics baseGraphics, BaseTransform baseTransform, Texture texture, PixelFormat pixelFormat) {
        this.validateTextureOp((BaseShaderGraphics)baseGraphics, baseTransform, texture, null, pixelFormat);
    }

    public Shader validateLCDOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture texture, Texture texture2, boolean bl, Paint paint) {
        Shader shader = bl ? this.getTextureFirstPassLCDShader() : this.getTextureSecondPassLCDShader();
        this.checkState(baseShaderGraphics, baseTransform, shader, texture, texture2);
        this.updatePerVertexColor(paint, baseShaderGraphics.getExtraAlpha());
        return shader;
    }

    Shader validateTextureOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture[] textureArray, PixelFormat pixelFormat) {
        Shader shader = null;
        if (pixelFormat == PixelFormat.MULTI_YCbCr_420) {
            if (textureArray.length < 3) {
                return null;
            }
            shader = this.externalShader == null ? this.getTextureYV12Shader() : this.externalShader;
        } else {
            return null;
        }
        if (null != shader) {
            this.checkState(baseShaderGraphics, baseTransform, shader, textureArray);
            this.updatePerVertexColor(null, baseShaderGraphics.getExtraAlpha());
        }
        return shader;
    }

    Shader validateTextureOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture texture, Texture texture2, PixelFormat pixelFormat) {
        Shader shader;
        block4: {
            block3: {
                if (this.externalShader != null) break block3;
                switch (pixelFormat) {
                    case INT_ARGB_PRE: 
                    case BYTE_BGRA_PRE: 
                    case BYTE_RGB: 
                    case BYTE_GRAY: 
                    case BYTE_APPLE_422: {
                        shader = this.getTextureRGBShader();
                        break block4;
                    }
                    default: {
                        throw new InternalError("Pixel format not supported: " + (Object)((Object)pixelFormat));
                    }
                }
            }
            shader = this.externalShader;
        }
        this.checkState(baseShaderGraphics, baseTransform, shader, texture, texture2);
        this.updatePerVertexColor(null, baseShaderGraphics.getExtraAlpha());
        return shader;
    }

    Shader validateMaskTextureOp(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Texture texture, Texture texture2, PixelFormat pixelFormat) {
        Shader shader;
        block4: {
            block3: {
                if (this.externalShader != null) break block3;
                switch (pixelFormat) {
                    case INT_ARGB_PRE: 
                    case BYTE_BGRA_PRE: 
                    case BYTE_RGB: 
                    case BYTE_GRAY: 
                    case BYTE_APPLE_422: {
                        shader = this.getTextureMaskRGBShader();
                        break block4;
                    }
                    default: {
                        throw new InternalError("Pixel format not supported: " + (Object)((Object)pixelFormat));
                    }
                }
            }
            shader = this.externalShader;
        }
        this.checkState(baseShaderGraphics, baseTransform, shader, texture, texture2);
        this.updatePerVertexColor(null, baseShaderGraphics.getExtraAlpha());
        return shader;
    }

    void setExternalShader(BaseShaderGraphics baseShaderGraphics, Shader shader) {
        this.flushVertexBuffer();
        if (shader != null) {
            shader.enable();
        }
        this.externalShader = shader;
    }

    private void checkState(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Shader shader, Texture texture, Texture texture2) {
        CompositeMode compositeMode;
        Rectangle rectangle;
        this.setRenderTarget(baseShaderGraphics);
        this.setTexture(0, texture);
        this.setTexture(1, texture2);
        if (shader != this.state.lastShader) {
            this.flushVertexBuffer();
            shader.enable();
            this.state.lastShader = shader;
            this.state.isXformValid = false;
        }
        if (!this.state.isXformValid || !baseTransform.equals(this.state.lastTransform)) {
            this.flushVertexBuffer();
            this.updateShaderTransform(shader, baseTransform);
            this.state.lastTransform.setTransform(baseTransform);
            this.state.isXformValid = true;
        }
        if ((rectangle = baseShaderGraphics.getClipRectNoClone()) != this.state.lastClip) {
            this.flushVertexBuffer();
            this.updateClipRect(rectangle);
            this.state.lastClip = rectangle;
        }
        if ((compositeMode = baseShaderGraphics.getCompositeMode()) != this.state.lastComp) {
            this.flushVertexBuffer();
            this.updateCompositeMode(compositeMode);
            this.state.lastComp = compositeMode;
        }
    }

    private void checkState(BaseShaderGraphics baseShaderGraphics, BaseTransform baseTransform, Shader shader, Texture[] textureArray) {
        CompositeMode compositeMode;
        Rectangle rectangle;
        this.setRenderTarget(baseShaderGraphics);
        int n = Math.max(0, Math.min(textureArray.length, 4));
        for (int i = 0; i < n; ++i) {
            this.setTexture(i, textureArray[i]);
        }
        if (shader != this.state.lastShader) {
            this.flushVertexBuffer();
            shader.enable();
            this.state.lastShader = shader;
            this.state.isXformValid = false;
        }
        if (!this.state.isXformValid || !baseTransform.equals(this.state.lastTransform)) {
            this.flushVertexBuffer();
            this.updateShaderTransform(shader, baseTransform);
            this.state.lastTransform.setTransform(baseTransform);
            this.state.isXformValid = true;
        }
        if ((rectangle = baseShaderGraphics.getClipRectNoClone()) != this.state.lastClip) {
            this.flushVertexBuffer();
            this.updateClipRect(rectangle);
            this.state.lastClip = rectangle;
        }
        if ((compositeMode = baseShaderGraphics.getCompositeMode()) != this.state.lastComp) {
            this.flushVertexBuffer();
            this.updateCompositeMode(compositeMode);
            this.state.lastComp = compositeMode;
        }
    }

    private void setTexture(int n, Texture texture) {
        if (texture != this.state.lastTextures[n]) {
            this.flushVertexBuffer();
            this.updateTexture(n, texture);
            ((State)this.state).lastTextures[n] = texture;
        }
    }

    public void initLCDBuffer(int n, int n2) {
        this.lcdBuffer = this.factory.createRTTexture(n, n2);
    }

    public void disposeLCDBuffer() {
        if (this.lcdBuffer != null) {
            this.lcdBuffer.dispose();
            this.lcdBuffer = null;
        }
    }

    @Override
    public RTTexture getLCDBuffer() {
        return this.lcdBuffer;
    }

    public void validateLCDBuffer(RenderTarget renderTarget) {
        if (this.lcdBuffer == null || this.lcdBuffer.getPhysicalWidth() < renderTarget.getPhysicalWidth() || this.lcdBuffer.getPhysicalHeight() < renderTarget.getPhysicalHeight()) {
            this.disposeLCDBuffer();
            this.initLCDBuffer(renderTarget.getPhysicalWidth(), renderTarget.getPhysicalHeight());
        }
    }

    @Override
    protected void setRenderTarget(RenderTarget renderTarget, PrismCameraImpl prismCameraImpl, boolean bl) {
        if (this.state == null || renderTarget != this.state.lastRenderTarget || prismCameraImpl != this.state.lastCamera || bl != this.state.lastDepthTest) {
            this.flushVertexBuffer();
            this.state = this.updateRenderTarget(renderTarget, prismCameraImpl, bl);
            this.state.lastRenderTarget = renderTarget;
            this.state.lastCamera = prismCameraImpl;
            this.state.lastDepthTest = bl;
            this.state.isXformValid = false;
        }
    }

    @Override
    protected void releaseRenderTarget() {
        if (this.state != null) {
            this.state.lastRenderTarget = null;
            for (int i = 0; i < this.state.lastTextures.length; ++i) {
                ((State)this.state).lastTextures[i] = null;
            }
        }
    }

    public static enum MaskType {
        SOLID("Solid"),
        TEXTURE("Texture"),
        FILL_PGRAM("FillPgram"),
        DRAW_PGRAM("DrawPgram", FILL_PGRAM),
        FILL_CIRCLE("FillCircle"),
        DRAW_CIRCLE("DrawCircle", FILL_CIRCLE),
        FILL_ELLIPSE("FillEllipse"),
        DRAW_ELLIPSE("DrawEllipse", FILL_ELLIPSE),
        FILL_ROUNDRECT("FillRoundRect"),
        DRAW_ROUNDRECT("DrawRoundRect", FILL_ROUNDRECT),
        DRAW_SEMIROUNDRECT("DrawSemiRoundRect"),
        FILL_CUBICCURVE("FillCubicCurve");

        private String name;
        private MaskType filltype;

        private MaskType(String string2) {
            this.name = string2;
        }

        private MaskType(String string2, MaskType maskType) {
            this.name = string2;
            this.filltype = maskType;
        }

        public String getName() {
            return this.name;
        }

        public MaskType getFillType() {
            return this.filltype;
        }
    }

    public static class State {
        private Shader lastShader;
        private RenderTarget lastRenderTarget;
        private PrismCameraImpl lastCamera;
        private boolean lastDepthTest;
        private BaseTransform lastTransform = new Affine3D();
        private Rectangle lastClip;
        private CompositeMode lastComp;
        private Texture[] lastTextures = new Texture[4];
        private boolean isXformValid;
        private float lastConst1;
        private float lastConst2;
        private float lastConst3;
        private float lastConst4;
        private float lastConst5;
        private float lastConst6;
    }
}

