/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.property;

import com.sun.javafx.binding.SetExpressionHelper;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlySetProperty;
import javafx.beans.property.SimpleSetProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableSet;
import javafx.collections.SetChangeListener;

public class ReadOnlySetWrapper<E>
extends SimpleSetProperty<E> {
    private ReadOnlyPropertyImpl readOnlyProperty;

    public ReadOnlySetWrapper() {
    }

    public ReadOnlySetWrapper(ObservableSet<E> observableSet) {
        super(observableSet);
    }

    public ReadOnlySetWrapper(Object object, String string) {
        super(object, string);
    }

    public ReadOnlySetWrapper(Object object, String string, ObservableSet<E> observableSet) {
        super(object, string, observableSet);
    }

    public ReadOnlySetProperty<E> getReadOnlyProperty() {
        if (this.readOnlyProperty == null) {
            this.readOnlyProperty = new ReadOnlyPropertyImpl();
        }
        return this.readOnlyProperty;
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.getReadOnlyProperty().addListener(invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(invalidationListener);
        }
    }

    @Override
    public void addListener(ChangeListener<? super ObservableSet<E>> changeListener) {
        this.getReadOnlyProperty().addListener(changeListener);
    }

    @Override
    public void removeListener(ChangeListener<? super ObservableSet<E>> changeListener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(changeListener);
        }
    }

    @Override
    public void addListener(SetChangeListener<? super E> setChangeListener) {
        this.getReadOnlyProperty().addListener(setChangeListener);
    }

    @Override
    public void removeListener(SetChangeListener<? super E> setChangeListener) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.removeListener(setChangeListener);
        }
    }

    @Override
    protected void fireValueChangedEvent() {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent();
        }
    }

    @Override
    protected void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
        if (this.readOnlyProperty != null) {
            this.readOnlyProperty.fireValueChangedEvent(change);
        }
    }

    private class ReadOnlyPropertyImpl
    extends ReadOnlySetProperty<E> {
        private SetExpressionHelper<E> helper = null;

        private ReadOnlyPropertyImpl() {
        }

        @Override
        public ObservableSet<E> get() {
            return ReadOnlySetWrapper.this.get();
        }

        @Override
        public void addListener(InvalidationListener invalidationListener) {
            this.helper = SetExpressionHelper.addListener(this.helper, this, invalidationListener);
        }

        @Override
        public void removeListener(InvalidationListener invalidationListener) {
            this.helper = SetExpressionHelper.removeListener(this.helper, invalidationListener);
        }

        @Override
        public void addListener(ChangeListener<? super ObservableSet<E>> changeListener) {
            this.helper = SetExpressionHelper.addListener(this.helper, this, changeListener);
        }

        @Override
        public void removeListener(ChangeListener<? super ObservableSet<E>> changeListener) {
            this.helper = SetExpressionHelper.removeListener(this.helper, changeListener);
        }

        @Override
        public void addListener(SetChangeListener<? super E> setChangeListener) {
            this.helper = SetExpressionHelper.addListener(this.helper, this, setChangeListener);
        }

        @Override
        public void removeListener(SetChangeListener<? super E> setChangeListener) {
            this.helper = SetExpressionHelper.removeListener(this.helper, setChangeListener);
        }

        private void fireValueChangedEvent() {
            SetExpressionHelper.fireValueChangedEvent(this.helper);
        }

        private void fireValueChangedEvent(SetChangeListener.Change<? extends E> change) {
            SetExpressionHelper.fireValueChangedEvent(this.helper, change);
        }

        @Override
        public Object getBean() {
            return ReadOnlySetWrapper.this.getBean();
        }

        @Override
        public String getName() {
            return ReadOnlySetWrapper.this.getName();
        }

        @Override
        public ReadOnlyIntegerProperty sizeProperty() {
            return ReadOnlySetWrapper.this.sizeProperty();
        }

        @Override
        public ReadOnlyBooleanProperty emptyProperty() {
            return ReadOnlySetWrapper.this.emptyProperty();
        }
    }
}

