/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.util.Accountable;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractAtomicParentChildFieldData;
import org.elasticsearch.search.MultiValueMode;

public class ParentChildAtomicFieldData
extends AbstractAtomicParentChildFieldData {
    private final ImmutableOpenMap<String, AtomicOrdinalsFieldData> typeToIds;
    private final long memorySizeInBytes;

    public ParentChildAtomicFieldData(ImmutableOpenMap<String, AtomicOrdinalsFieldData> typeToIds) {
        this.typeToIds = typeToIds;
        long size = 0L;
        for (ObjectCursor cursor : typeToIds.values()) {
            size += ((AtomicOrdinalsFieldData)cursor.value).ramBytesUsed();
        }
        this.memorySizeInBytes = size;
    }

    public long ramBytesUsed() {
        return this.memorySizeInBytes;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> types() {
        HashSet<String> types = new HashSet<String>();
        for (ObjectCursor cursor : this.typeToIds.keys()) {
            types.add((String)cursor.value);
        }
        return types;
    }

    @Override
    public SortedDocValues getOrdinalsValues(String type) {
        AtomicOrdinalsFieldData atomicFieldData = this.typeToIds.get(type);
        if (atomicFieldData != null) {
            return MultiValueMode.MIN.select(atomicFieldData.getOrdinalsValues());
        }
        return DocValues.emptySorted();
    }

    public AtomicOrdinalsFieldData getAtomicFieldData(String type) {
        return this.typeToIds.get(type);
    }

    @Override
    public void close() {
        for (ObjectCursor cursor : this.typeToIds.values()) {
            ((AtomicOrdinalsFieldData)cursor.value).close();
        }
    }
}

