/*
 * Decompiled with CFR 0.152.
 */
package esmska.gui;

import esmska.data.Config;
import esmska.data.Contact;
import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Keyring;
import esmska.data.event.AbstractDocumentListener;
import esmska.data.event.ActionEventSupport;
import esmska.gui.Actions;
import esmska.gui.ClipboardPopupMenu;
import esmska.gui.GatewayComboBox;
import esmska.gui.InfoLabel;
import esmska.gui.ThemeManager;
import esmska.utils.L10N;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import org.apache.commons.lang.StringUtils;
import org.openide.awt.Mnemonics;

public class EditContactPanel
extends JPanel {
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private Config config = Config.getInstance();
    private Keyring keyring = Keyring.getInstance();
    private boolean multiMode;
    private boolean userSet;
    private ActionEventSupport actionSupport = new ActionEventSupport(this);
    private InfoLabel countryInfoLabel;
    private InfoLabel credentialsInfoLabel;
    private GatewayComboBox gatewayComboBox;
    private JLabel gatewayLabel;
    private JPanel infoPanel;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel nameWarnLabel;
    private JLabel numberLabel;
    private JTextField numberTextField;
    private JLabel numberWarnLabel;
    private JButton suggestGatewayButton;

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    public EditContactPanel() {
        this.initComponents();
        if (!this.config.getLookAndFeel().equals((Object)ThemeManager.LAF.SUBSTANCE)) {
            ClipboardPopupMenu.register(this.nameTextField);
            ClipboardPopupMenu.register(this.numberTextField);
        }
        this.numberTextField.getDocument().addDocumentListener(new AbstractDocumentListener(){

            @Override
            public void onUpdate(DocumentEvent e) {
                boolean usrSet = EditContactPanel.this.userSet;
                if (!EditContactPanel.this.userSet) {
                    EditContactPanel.this.gatewayComboBox.selectSuggestedGateway(EditContactPanel.this.numberTextField.getText());
                }
                EditContactPanel.this.gatewayComboBox.setFilter(EditContactPanel.this.numberTextField.getText());
                EditContactPanel.this.userSet = usrSet;
                EditContactPanel.this.updateCountryInfoLabel();
                EditContactPanel.this.updateSuggestGatewayButton();
                EditContactPanel.this.revalidate();
            }
        });
        this.keyring.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditContactPanel.this.updateCredentialsInfoLabel();
                EditContactPanel.this.revalidate();
            }
        });
        ComponentAdapter resizeListener = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                this.askForResize();
            }

            @Override
            public void componentShown(ComponentEvent e) {
                this.askForResize();
            }

            private void askForResize() {
                EditContactPanel.this.actionSupport.fireActionPerformed(0, null);
            }
        };
        for (Component comp : this.infoPanel.getComponents()) {
            comp.addComponentListener(resizeListener);
        }
        this.gatewayComboBoxActionPerformed(null);
    }

    private void updateSuggestGatewayButton() {
        ArrayList<Gateway> gws = Gateways.getInstance().suggestGateway(this.numberTextField.getText()).get1();
        boolean visible = false;
        if (gws.size() > 1) {
            visible = true;
        }
        if (gws.size() == 1 && this.gatewayComboBox.getSelectedGateway() != gws.get(0)) {
            visible = true;
        }
        this.suggestGatewayButton.setVisible(visible);
    }

    private void initComponents() {
        this.nameTextField = new JTextField();
        this.nameTextField.requestFocusInWindow();
        this.numberTextField = new JTextField(){

            @Override
            public String getText() {
                String text = super.getText();
                if (StringUtils.isNotEmpty(text) && !text.startsWith("+")) {
                    text = EditContactPanel.this.config.getCountryPrefix() + text;
                }
                return text;
            }
        };
        this.gatewayComboBox = new GatewayComboBox();
        this.nameLabel = new JLabel();
        this.numberLabel = new JLabel();
        this.gatewayLabel = new JLabel();
        this.suggestGatewayButton = new JButton();
        this.infoPanel = new JPanel();
        this.countryInfoLabel = new InfoLabel();
        this.credentialsInfoLabel = new InfoLabel();
        this.nameWarnLabel = new JLabel();
        this.numberWarnLabel = new JLabel();
        this.nameTextField.setToolTipText(l10n.getString("EditContactPanel.nameTextField.toolTipText"));
        this.nameTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EditContactPanel.this.nameTextFieldFocusLost(evt);
            }
        });
        this.numberTextField.setColumns(13);
        this.numberTextField.setToolTipText(l10n.getString("EditContactPanel.numberTextField.toolTipText"));
        this.numberTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EditContactPanel.this.numberTextFieldFocusLost(evt);
            }
        });
        this.gatewayComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditContactPanel.this.gatewayComboBoxActionPerformed(evt);
            }
        });
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText(this.nameLabel, l10n.getString("EditContactPanel.nameLabel.text"));
        this.nameLabel.setToolTipText(this.nameTextField.getToolTipText());
        this.numberLabel.setLabelFor(this.numberTextField);
        Mnemonics.setLocalizedText(this.numberLabel, l10n.getString("EditContactPanel.numberLabel.text"));
        this.numberLabel.setToolTipText(this.numberTextField.getToolTipText());
        this.gatewayLabel.setLabelFor(this.gatewayComboBox);
        Mnemonics.setLocalizedText(this.gatewayLabel, l10n.getString("EditContactPanel.gatewayLabel.text"));
        this.gatewayLabel.setToolTipText(this.gatewayComboBox.getToolTipText());
        this.suggestGatewayButton.setAction(new SuggestGatewayAction());
        Mnemonics.setLocalizedText(this.countryInfoLabel, l10n.getString("EditContactPanel.countryInfoLabel.text"));
        this.countryInfoLabel.setVisible(false);
        Mnemonics.setLocalizedText(this.credentialsInfoLabel, l10n.getString("EditContactPanel.credentialsInfoLabel.text"));
        this.credentialsInfoLabel.setText(MessageFormat.format(l10n.getString("EditContactPanel.credentialsInfoLabel.text"), "esmska://config-gateways"));
        this.credentialsInfoLabel.setVisible(false);
        GroupLayout infoPanelLayout = new GroupLayout(this.infoPanel);
        this.infoPanel.setLayout(infoPanelLayout);
        infoPanelLayout.setHorizontalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.credentialsInfoLabel, GroupLayout.Alignment.TRAILING, -1, 411, Short.MAX_VALUE).addComponent(this.countryInfoLabel, -1, 411, Short.MAX_VALUE));
        infoPanelLayout.setVerticalGroup(infoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(infoPanelLayout.createSequentialGroup().addComponent(this.credentialsInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countryInfoLabel)));
        this.nameWarnLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/warning-16.png")));
        this.nameWarnLabel.setToolTipText(this.nameTextField.getToolTipText());
        this.nameWarnLabel.setVisible(false);
        this.numberWarnLabel.setIcon(new ImageIcon(this.getClass().getResource("/esmska/resources/warning-16.png")));
        this.numberWarnLabel.setToolTipText(this.numberTextField.getToolTipText());
        this.numberWarnLabel.setVisible(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.infoPanel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.numberLabel).addComponent(this.nameLabel).addComponent(this.gatewayLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.gatewayComboBox, -1, 266, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.suggestGatewayButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.numberTextField, -1, 278, Short.MAX_VALUE).addComponent(this.nameTextField, GroupLayout.Alignment.TRAILING, -1, 278, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.nameWarnLabel, GroupLayout.Alignment.TRAILING).addComponent(this.numberWarnLabel, GroupLayout.Alignment.TRAILING)))))).addContainerGap()));
        layout.linkSize(0, this.gatewayLabel, this.nameLabel, this.numberLabel);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addComponent(this.nameWarnLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numberLabel).addComponent(this.numberTextField, -2, -1, -2)).addComponent(this.numberWarnLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.gatewayLabel).addComponent(this.gatewayComboBox, -2, -1, -2)).addComponent(this.suggestGatewayButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.infoPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.nameTextField, this.nameWarnLabel, this.numberTextField, this.numberWarnLabel);
    }

    public boolean validateForm() {
        boolean valid = true;
        boolean focusTransfered = false;
        JComponent[] comps = this.multiMode ? new JComponent[]{} : new JComponent[]{this.nameTextField, this.numberTextField};
        for (JComponent c : comps) {
            boolean bl = valid = this.checkValid(c) && valid;
            if (valid || focusTransfered) continue;
            c.requestFocusInWindow();
            focusTransfered = true;
        }
        this.revalidate();
        return valid;
    }

    private boolean checkValid(JComponent c) {
        boolean valid = true;
        if (c == this.nameTextField) {
            valid = StringUtils.isNotEmpty(this.nameTextField.getText());
            this.nameWarnLabel.setVisible(!valid);
        } else if (c == this.numberTextField) {
            valid = Contact.isValidNumber(this.numberTextField.getText());
            this.numberWarnLabel.setVisible(!valid);
        }
        return valid;
    }

    private void setMultiMode(boolean multiMode) {
        this.multiMode = multiMode;
        this.nameTextField.setEnabled(!multiMode);
        this.numberTextField.setEnabled(!multiMode);
        this.suggestGatewayButton.setVisible(!multiMode);
        this.revalidate();
    }

    private void updateCountryInfoLabel() {
        this.countryInfoLabel.setVisible(false);
        Gateway gateway = this.gatewayComboBox.getSelectedGateway();
        String number = this.numberTextField.getText();
        if (gateway == null || !Contact.isValidNumber(number)) {
            return;
        }
        boolean supported = Gateways.isNumberSupported(gateway, number);
        if (!supported) {
            String text = MessageFormat.format(l10n.getString("EditContactPanel.countryInfoLabel.text"), StringUtils.join((Object[])gateway.getSupportedPrefixes(), ','));
            this.countryInfoLabel.setText(text);
            this.countryInfoLabel.setVisible(true);
        }
    }

    private void updateCredentialsInfoLabel() {
        Gateway gateway = this.gatewayComboBox.getSelectedGateway();
        if (gateway != null && gateway.hasFeature(Gateway.Feature.LOGIN_ONLY) && this.keyring.getKey(gateway.getName()) == null) {
            this.credentialsInfoLabel.setVisible(true);
        } else {
            this.credentialsInfoLabel.setVisible(false);
        }
    }

    private void nameTextFieldFocusLost(FocusEvent evt) {
        this.checkValid(this.nameTextField);
    }

    private void numberTextFieldFocusLost(FocusEvent evt) {
        this.checkValid(this.numberTextField);
    }

    private void gatewayComboBoxActionPerformed(ActionEvent evt) {
        this.userSet = evt != null;
        this.updateCredentialsInfoLabel();
        this.updateCountryInfoLabel();
        this.updateSuggestGatewayButton();
        this.revalidate();
    }

    public void setContact(Contact contact) {
        this.setMultiMode(false);
        if (contact == null) {
            this.nameTextField.setText(null);
            this.numberTextField.setText(this.config.getCountryPrefix());
        } else {
            this.nameTextField.setText(contact.getName());
            this.numberTextField.setText(contact.getNumber());
            this.gatewayComboBox.setSelectedGateway(contact.getGateway());
        }
        this.userSet = false;
    }

    public void setContacts(Collection<Contact> contacts) {
        if (contacts.size() <= 1) {
            this.setContact(contacts.size() <= 0 ? null : contacts.iterator().next());
            return;
        }
        this.setMultiMode(true);
        this.gatewayComboBox.setSelectedGateway(contacts.iterator().next().getGateway());
    }

    public Contact getContact() {
        String name = this.nameTextField.getText();
        String number = this.numberTextField.getText();
        String gateway = this.gatewayComboBox.getSelectedGatewayName();
        if (!this.multiMode && (StringUtils.isEmpty(name) || StringUtils.isEmpty(number) || StringUtils.isEmpty(gateway))) {
            return null;
        }
        return new Contact(name, number, gateway);
    }

    public void prepareForShow() {
        if (this.multiMode) {
            this.gatewayComboBox.requestFocusInWindow();
        } else {
            this.nameTextField.requestFocusInWindow();
            this.nameTextField.selectAll();
        }
    }

    private class SuggestGatewayAction
    extends Actions.SuggestGatewayAction {
        public SuggestGatewayAction() {
            super(EditContactPanel.this.gatewayComboBox, EditContactPanel.this.numberTextField);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            EditContactPanel.this.userSet = false;
        }
    }
}

