/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.impl.sambox.component.optimizaton;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.sejda.impl.sambox.component.optimizaton.Optimizers;
import org.sejda.model.optimization.Optimization;
import org.sejda.sambox.pdmodel.PDDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentOptimizer
implements Consumer<PDDocument> {
    private static final Logger LOG = LoggerFactory.getLogger(DocumentOptimizer.class);
    private Consumer<PDDocument> optimizer = d -> LOG.debug("Optimizing document");

    public DocumentOptimizer(Set<Optimization> optimizations) {
        Optional.ofNullable(optimizations).orElse(Collections.emptySet()).forEach(o -> Optional.ofNullable(Optimizers.documentOptimizer(o)).ifPresent(toAdd -> {
            this.optimizer = this.optimizer.andThen((Consumer<PDDocument>)toAdd);
        }));
    }

    @Override
    public void accept(PDDocument d) {
        this.optimizer.accept(d);
    }
}

