/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.element;

import com.baselet.control.HandlerElementMap;
import com.baselet.control.enums.AlignHorizontal;
import com.baselet.control.util.Utils;
import com.baselet.element.old.OldGridElement;
import com.baselet.element.sticking.StickingPolygon;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;

public class Taxonomy_of_Workprocesses
extends OldGridElement {
    @Override
    public void paintEntity(Graphics g) {
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        Graphics2D g2 = (Graphics2D)g;
        g2.setFont(HandlerElementMap.getHandlerForElement(this).getFontHandler().getFont());
        Composite[] composites = this.colorize(g2);
        g2.setColor(this.fgColor);
        g2.setComposite(composites[1]);
        g2.setColor(this.bgColor);
        g2.fillRect(0, 0, this.getRectangle().width - 1, this.getRectangle().height - 1);
        g2.setComposite(composites[0]);
        if (HandlerElementMap.getHandlerForElement(this).getDrawPanel().getSelector().isSelected(this)) {
            g2.setColor(this.fgColor);
        } else {
            g2.setColor(this.fgColorBase);
        }
        g2.drawRect(0, 0, this.getRectangle().width - 1, this.getRectangle().height - 1);
        Vector<String> tmp = Utils.decomposeStrings(this.getPanelAttributes());
        int level = 0;
        double yPos = 10.0f * zoom;
        double xPos = 10.0f * zoom;
        double dist = 10.0 * HandlerElementMap.getHandlerForElement(this).getFontHandler().getDistanceBetweenTexts();
        double ovalHeight = 3.0 * HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize();
        double ovalWidth = 10.0 * HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize();
        Point nextDock = new Point((int)(xPos + ovalWidth / 2.0 + 0.5), (int)(ovalHeight + yPos + 0.5));
        Vector<Point> dock = new Vector<Point>();
        dock.add(nextDock);
        for (int i = 0; i < tmp.size(); ++i) {
            String s = tmp.elementAt(i);
            int currentLineLevel = this.calculateLevel(s);
            s = s.replaceAll("\t", "");
            if (currentLineLevel > level && i > 0) {
                nextDock = new Point((int)(xPos + ovalWidth / 2.0 + 0.5), (int)(ovalHeight + yPos + 0.5));
                dock.add(nextDock);
                nextDock = (Point)dock.elementAt(++level - 1);
                this.drawDockAnchor(g2, nextDock);
            }
            if (currentLineLevel < level) {
                level = currentLineLevel;
            }
            xPos = (double)(10.0f * zoom) + ovalWidth * (double)level;
            this.drawProcess(g2, xPos, yPos, s);
            if (level > 0) {
                Color color = g2.getColor();
                if (currentLineLevel > level) {
                    g2.setColor(Color.red);
                }
                nextDock = (Point)dock.elementAt(level - 1);
                this.drawDock(g2, nextDock, xPos, yPos);
                g2.setColor(color);
            }
            nextDock = new Point((int)(xPos + ovalWidth / 2.0 + 0.5), (int)(yPos + ovalHeight + 0.5));
            dock.set(level, nextDock);
            yPos += 2.0 * ovalHeight - dist;
        }
    }

    @Override
    public StickingPolygon generateStickingBorder() {
        StickingPolygon p = new StickingPolygon(0, 0);
        return p;
    }

    private void drawProcess(Graphics2D g2, double xPos, double yPos, String name) {
        double zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        double ovalHeight = 3.0 * HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize();
        double ovalWidth = 10.0 * HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize();
        g2.drawOval((int)(xPos + 0.5), (int)(yPos + 0.5), (int)(ovalWidth + 0.5), (int)(ovalHeight + 0.5));
        HandlerElementMap.getHandlerForElement(this).getFontHandler().writeText(g2, name, (double)((int)(xPos + ovalWidth / 2.0 + 0.5)), (double)((int)(yPos + 5.0 * zoom + ovalHeight / 2.0 + 0.5)), AlignHorizontal.CENTER);
    }

    private void drawDock(Graphics2D g2, Point nextDock, double xPos, double yPos) {
        double zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        double ovalHeight = 3.0 * HandlerElementMap.getHandlerForElement(this).getFontHandler().getFontSize();
        g2.drawLine(nextDock.x, (int)((double)nextDock.y + 9.0 * zoom + 0.5), nextDock.x, (int)(ovalHeight / 2.0 + yPos + 0.5));
        g2.drawLine(nextDock.x, (int)(ovalHeight / 2.0 + yPos + 0.5), (int)(xPos + 0.5), (int)(ovalHeight / 2.0 + yPos + 0.5));
    }

    private void drawDockAnchor(Graphics2D g2, Point nextDock) {
        float zoom = HandlerElementMap.getHandlerForElement(this).getZoomFactor();
        int[] xkanten = new int[]{nextDock.x, nextDock.x + (int)(6.0f * zoom), nextDock.x - (int)(6.0f * zoom)};
        int[] ykanten = new int[]{nextDock.y, nextDock.y + (int)(9.0f * zoom), nextDock.y + (int)(9.0f * zoom)};
        int kanten_zahl = 3;
        g2.drawPolygon(new Polygon(xkanten, ykanten, kanten_zahl));
    }

    protected int calculateLevel(String s) {
        int level = 0;
        while (s.length() > 0 && s.charAt(0) == '\t') {
            ++level;
            s = s.substring(1);
        }
        return level;
    }
}

