/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.io.UnsupportedEncodingException;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;
import org.pentaho.reporting.libraries.formula.util.URLEncoder;

public class URLEncodeFunction
implements Function {
    private static final long serialVersionUID = 646428113862238221L;

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        String encodingResult;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type textType = parameters.getType(0);
        Object textValue = parameters.getValue(0);
        String textResult = context.getTypeRegistry().convertToText(textType, textValue);
        if (textResult == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (parameterCount == 2) {
            Type encodingType = parameters.getType(1);
            Object encodingValue = parameters.getValue(1);
            encodingResult = context.getTypeRegistry().convertToText(encodingType, encodingValue);
            if (encodingResult == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
        } else {
            encodingResult = "ISO-8859-1";
        }
        try {
            return new TypeValuePair(TextType.TYPE, URLEncoder.encode(textResult, encodingResult));
        }
        catch (UnsupportedEncodingException use) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
    }

    public String getCanonicalName() {
        return "URLENCODE";
    }
}

