/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.container;

import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.io.XInputStream;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.script.framework.container.Parcel;
import com.sun.star.script.framework.container.ParcelDescriptor;
import com.sun.star.script.framework.container.ParsedScriptUri;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.io.XInputStreamImpl;
import com.sun.star.script.framework.io.XInputStreamWrapper;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.PathUtils;
import com.sun.star.ucb.CommandAbortedException;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.ucb.XSimpleFileAccess2;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.XUriReference;
import com.sun.star.uri.XUriReferenceFactory;
import com.sun.star.uri.XVndSunStarScriptUrl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class ParcelContainer
implements XNameAccess {
    protected String language;
    protected String containerUrl;
    private Collection<Parcel> parcels = new ArrayList<Parcel>(10);
    protected static XSimpleFileAccess m_xSFA;
    protected XComponentContext m_xCtx;
    private ParcelContainer parent = null;
    private final Collection<ParcelContainer> childContainers = new ArrayList<ParcelContainer>(10);
    private boolean isPkgContainer = false;

    public boolean isUnoPkg() {
        return this.isPkgContainer;
    }

    public ParcelContainer parent() {
        return this.parent;
    }

    public ParcelContainer[] getChildContainers() {
        if (this.childContainers.isEmpty()) {
            return new ParcelContainer[0];
        }
        return this.childContainers.toArray(new ParcelContainer[this.childContainers.size()]);
    }

    public boolean removeChildContainer(ParcelContainer child) {
        return this.childContainers.remove(child);
    }

    public void addChildContainer(ParcelContainer child) {
        this.childContainers.add(child);
    }

    public ParcelContainer getChildContainer(String key) {
        ParcelContainer result = null;
        for (ParcelContainer c : this.childContainers) {
            String location = ScriptMetaData.getLocationPlaceHolder(c.containerUrl, c.getName());
            if (!key.equals(location)) continue;
            result = c;
            break;
        }
        return result;
    }

    public ParcelContainer getChildContainerForURL(String containerUrl) {
        ParcelContainer result = null;
        for (ParcelContainer c : this.childContainers) {
            if (!containerUrl.equals(c.containerUrl)) continue;
            result = c;
            break;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getName() {
        String name = null;
        if (this.containerUrl.startsWith("vnd.sun.star.tdoc:")) return "document";
        try {
            String decodedUrl = URLDecoder.decode(this.containerUrl, "UTF-8");
            int indexOfSlash = decodedUrl.lastIndexOf(47);
            if (indexOfSlash == -1) return name;
            return decodedUrl.substring(indexOfSlash + 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException((Throwable)e);
        }
    }

    public ParcelContainer(XComponentContext xCtx, String containerUrl, String language) throws IllegalArgumentException, WrappedTargetException {
        this(null, xCtx, containerUrl, language, true);
    }

    public ParcelContainer(XComponentContext xCtx, String containerUrl, String language, boolean loadParcels) throws IllegalArgumentException, WrappedTargetException {
        this(null, xCtx, containerUrl, language, loadParcels);
    }

    public ParcelContainer(ParcelContainer parent, XComponentContext xCtx, String containerUrl, String language, boolean loadParcels) throws IllegalArgumentException, WrappedTargetException {
        LogUtils.DEBUG("Creating ParcelContainer for " + containerUrl + " loadParcels = " + loadParcels + " language = " + language);
        this.m_xCtx = xCtx;
        this.language = language;
        this.parent = parent;
        this.containerUrl = containerUrl;
        this.initSimpleFileAccess();
        boolean parentIsPkgContainer = false;
        if (parent != null) {
            parentIsPkgContainer = parent.isUnoPkg();
        }
        if (containerUrl.endsWith("uno_packages") || parentIsPkgContainer) {
            this.isPkgContainer = true;
        }
        if (loadParcels) {
            this.loadParcels();
        }
    }

    public String getContainerURL() {
        return this.containerUrl;
    }

    private synchronized void initSimpleFileAccess() {
        if (m_xSFA != null) {
            return;
        }
        try {
            m_xSFA = (XSimpleFileAccess)UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)this.m_xCtx.getServiceManager().createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", this.m_xCtx));
        }
        catch (Exception e) {
            LogUtils.DEBUG("Error instantiating simplefile access ");
            LogUtils.DEBUG(LogUtils.getTrace(e));
        }
    }

    public String getParcelContainerDir() {
        if (!this.isUnoPkg()) {
            return PathUtils.make_url(this.containerUrl, "Scripts/" + this.language.toLowerCase());
        }
        return this.containerUrl;
    }

    public Object getByName(String aName) throws NoSuchElementException, WrappedTargetException {
        Parcel parcel;
        block4: {
            parcel = null;
            try {
                if (!this.hasElements()) break block4;
                for (Parcel parcelToCheck : this.parcels) {
                    if (!parcelToCheck.getName().equals(aName)) continue;
                    parcel = parcelToCheck;
                    break;
                }
            }
            catch (Exception e) {
                throw new WrappedTargetException((Throwable)e);
            }
        }
        if (parcel == null) {
            throw new NoSuchElementException("Macro Library " + aName + " not found");
        }
        return parcel;
    }

    public String[] getElementNames() {
        if (this.hasElements()) {
            Parcel[] theParcels = this.parcels.toArray(new Parcel[this.parcels.size()]);
            String[] names = new String[theParcels.length];
            for (int count = 0; count < names.length; ++count) {
                names[count] = theParcels[count].getName();
            }
            return names;
        }
        return new String[0];
    }

    public boolean hasByName(String aName) {
        boolean isFound = false;
        try {
            if (this.getByName(aName) != null) {
                isFound = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isFound;
    }

    public Type getElementType() {
        return new Type();
    }

    public boolean hasElements() {
        return this.parcels != null && !this.parcels.isEmpty();
    }

    private void loadParcels() throws IllegalArgumentException, WrappedTargetException {
        try {
            LogUtils.DEBUG("About to load parcels from " + this.containerUrl);
            if (m_xSFA.isFolder(this.getParcelContainerDir())) {
                LogUtils.DEBUG(this.getParcelContainerDir() + " is a folder ");
                String[] children = m_xSFA.getFolderContents(this.getParcelContainerDir(), true);
                this.parcels = new ArrayList<Parcel>(children.length);
                for (String child : children) {
                    LogUtils.DEBUG("Processing " + child);
                    try {
                        this.loadParcel(child);
                    }
                    catch (Exception e) {
                        LogUtils.DEBUG("ParcelContainer.loadParcels caught " + e.getClass().getName() + " exception loading parcel " + child + ": " + e.getMessage());
                    }
                }
            } else {
                LogUtils.DEBUG(" ParcelCOntainer.loadParcels " + this.getParcelContainerDir() + " is not a folder ");
            }
        }
        catch (CommandAbortedException e) {
            LogUtils.DEBUG("ParcelContainer.loadParcels caught exception processing folders for " + this.getParcelContainerDir());
            LogUtils.DEBUG("TRACE: " + LogUtils.getTrace((Exception)((Object)e)));
            throw new WrappedTargetException((Throwable)e);
        }
        catch (com.sun.star.uno.Exception e) {
            LogUtils.DEBUG("ParcelContainer.loadParcels caught exception processing folders for " + this.getParcelContainerDir());
            LogUtils.DEBUG("TRACE: " + LogUtils.getTrace((Exception)((Object)e)));
            throw new WrappedTargetException((Throwable)e);
        }
    }

    public XNameContainer createParcel(String name) throws ElementExistException, WrappedTargetException {
        Parcel p = null;
        if (this.hasByName(name)) {
            throw new ElementExistException("Parcel " + name + " already exists");
        }
        String pathToParcel = PathUtils.make_url(this.getParcelContainerDir(), name);
        try {
            LogUtils.DEBUG("ParcelContainer.createParcel, creating folder " + pathToParcel);
            m_xSFA.createFolder(pathToParcel);
            LogUtils.DEBUG("ParcelContainer.createParcel, folder " + pathToParcel + " created ");
            ParcelDescriptor pd = new ParcelDescriptor();
            pd.setLanguage(this.language);
            String parcelDesc = PathUtils.make_url(pathToParcel, "parcel-descriptor.xml");
            XSimpleFileAccess2 xSFA2 = (XSimpleFileAccess2)UnoRuntime.queryInterface(XSimpleFileAccess2.class, (Object)m_xSFA);
            if (xSFA2 != null) {
                LogUtils.DEBUG("createParcel() Using XSIMPLEFILEACCESS2 " + parcelDesc);
                ByteArrayOutputStream bos = new ByteArrayOutputStream(1024);
                pd.write(bos);
                bos.close();
                ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                XInputStreamImpl xis = new XInputStreamImpl(bis);
                xSFA2.writeFile(parcelDesc, (XInputStream)xis);
                xis.closeInput();
                p = this.loadParcel(pathToParcel);
            }
        }
        catch (Exception e) {
            LogUtils.DEBUG("createParcel() Exception while attempting to create = " + name);
            throw new WrappedTargetException((Throwable)e);
        }
        return p;
    }

    public Parcel loadParcel(String parcelUrl) throws WrappedTargetException, IllegalArgumentException {
        Parcel parcel;
        block27: {
            String parcelDescUrl = PathUtils.make_url(parcelUrl, "parcel-descriptor.xml");
            parcel = null;
            XInputStream xis = null;
            InputStream is = null;
            try {
                if (m_xSFA.exists(parcelDescUrl)) {
                    LogUtils.DEBUG("ParcelContainer.loadParcel opening " + parcelDescUrl);
                    xis = m_xSFA.openFileRead(parcelDescUrl);
                    is = new XInputStreamWrapper(xis);
                    ParcelDescriptor pd = new ParcelDescriptor(is);
                    try {
                        is.close();
                        is = null;
                    }
                    catch (Exception e) {
                        LogUtils.DEBUG("ParcelContainer.loadParcel Exception when closing stream for  " + parcelDescUrl + " :" + e);
                    }
                    LogUtils.DEBUG("ParcelContainer.loadParcel closed " + parcelDescUrl);
                    if (!pd.getLanguage().equals(this.language)) {
                        LogUtils.DEBUG("ParcelContainer.loadParcel Language of Parcel does not match this container ");
                        Parcel e = null;
                        return e;
                    }
                    LogUtils.DEBUG("Processing " + parcelDescUrl + " closed ");
                    int indexOfSlash = parcelUrl.lastIndexOf(47);
                    String name = parcelUrl.substring(indexOfSlash + 1);
                    parcel = new Parcel(m_xSFA, this, pd, name);
                    LogUtils.DEBUG(" ParcelContainer.loadParcel created parcel for " + parcelDescUrl + " for language " + this.language);
                    this.parcels.add(parcel);
                    break block27;
                }
                throw new IOException(parcelDescUrl + " does NOT exist!");
            }
            catch (CommandAbortedException e) {
                LogUtils.DEBUG("loadParcel() Exception while accessing filesystem url = " + parcelDescUrl + (Object)((Object)e));
                throw new WrappedTargetException((Throwable)e);
            }
            catch (IOException e) {
                LogUtils.DEBUG("ParcelContainer.loadParcel() caught IOException while accessing " + parcelDescUrl + ": " + e);
                throw new WrappedTargetException((Throwable)e);
            }
            catch (com.sun.star.uno.Exception e) {
                LogUtils.DEBUG("loadParcel() Exception while accessing filesystem url = " + parcelDescUrl + (Object)((Object)e));
                throw new WrappedTargetException((Throwable)e);
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                } else if (xis != null) {
                    try {
                        xis.closeInput();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return parcel;
    }

    public void renameParcel(String oldName, String newName) throws NoSuchElementException, WrappedTargetException {
        LogUtils.DEBUG(" ** ParcelContainer Renaming parcel " + oldName + " to " + newName);
        LogUtils.DEBUG(" ** ParcelContainer is " + this);
        Parcel p = (Parcel)this.getByName(oldName);
        if (p == null) {
            throw new NoSuchElementException("No parcel named " + oldName);
        }
        String oldParcelDirUrl = PathUtils.make_url(this.getParcelContainerDir(), oldName);
        String newParcelDirUrl = PathUtils.make_url(this.getParcelContainerDir(), newName);
        try {
            if (!m_xSFA.isFolder(oldParcelDirUrl)) {
                com.sun.star.io.IOException e = new com.sun.star.io.IOException("Invalid Parcel directory: " + oldName);
                throw new WrappedTargetException((Throwable)e);
            }
            LogUtils.DEBUG(" ** ParcelContainer Renaming folder " + oldParcelDirUrl + " to " + newParcelDirUrl);
            m_xSFA.move(oldParcelDirUrl, newParcelDirUrl);
        }
        catch (CommandAbortedException ce) {
            LogUtils.DEBUG(" ** ParcelContainer Renaming failed with " + (Object)((Object)ce));
            throw new WrappedTargetException((Throwable)ce);
        }
        catch (com.sun.star.uno.Exception e) {
            LogUtils.DEBUG(" ** ParcelContainer Renaming failed with " + (Object)((Object)e));
            throw new WrappedTargetException((Throwable)e);
        }
        p.rename(newName);
    }

    public boolean removeParcel(String name) throws NoSuchElementException, WrappedTargetException {
        Parcel p = (Parcel)this.getByName(name);
        if (p == null) {
            throw new NoSuchElementException("No parcel named " + name);
        }
        return this.parcels.remove(p);
    }

    public boolean deleteParcel(String name) throws NoSuchElementException, WrappedTargetException {
        LogUtils.DEBUG("deleteParcel for containerURL " + this.containerUrl + " name = " + name + " Langueg = " + this.language);
        Parcel p = (Parcel)this.getByName(name);
        if (p == null) {
            throw new NoSuchElementException("No parcel named " + name);
        }
        try {
            String pathToParcel = PathUtils.make_url(this.getParcelContainerDir(), name);
            m_xSFA.kill(pathToParcel);
        }
        catch (Exception e) {
            LogUtils.DEBUG("Error deleting parcel " + name);
            throw new WrappedTargetException((Throwable)e);
        }
        return this.parcels.remove(p);
    }

    public String getLanguage() {
        return this.language;
    }

    public ScriptMetaData findScript(ParsedScriptUri parsedUri) throws NoSuchElementException, WrappedTargetException {
        Parcel p = (Parcel)this.getByName(parsedUri.parcel);
        ScriptMetaData scriptData = (ScriptMetaData)p.getByName(parsedUri.function);
        LogUtils.DEBUG("** found script data for " + parsedUri.function + " script is " + scriptData);
        return scriptData;
    }

    public ParsedScriptUri parseScriptUri(String scriptURI) throws IllegalArgumentException {
        XMultiComponentFactory xMcFac = null;
        XUriReferenceFactory xFac = null;
        try {
            xMcFac = this.m_xCtx.getServiceManager();
            xFac = (XUriReferenceFactory)UnoRuntime.queryInterface(XUriReferenceFactory.class, (Object)xMcFac.createInstanceWithContext("com.sun.star.uri.UriReferenceFactory", this.m_xCtx));
        }
        catch (com.sun.star.uno.Exception e) {
            LogUtils.DEBUG("Problems parsing  URL:" + e.toString());
            throw new IllegalArgumentException((Throwable)e, "Problems parsing URL");
        }
        if (xFac == null) {
            LogUtils.DEBUG("Failed to create UrlReference factory");
            throw new IllegalArgumentException("Failed to create UrlReference factory for url " + scriptURI);
        }
        XUriReference uriRef = xFac.parse(scriptURI);
        XVndSunStarScriptUrl sfUri = (XVndSunStarScriptUrl)UnoRuntime.queryInterface(XVndSunStarScriptUrl.class, (Object)uriRef);
        if (sfUri == null) {
            LogUtils.DEBUG("Failed to parse url");
            throw new IllegalArgumentException("Failed to parse url " + scriptURI);
        }
        ParsedScriptUri parsedUri = new ParsedScriptUri();
        parsedUri.function = sfUri.getName();
        parsedUri.parcel = "";
        StringTokenizer tokenizer = new StringTokenizer(parsedUri.function, ".");
        if (tokenizer.hasMoreElements()) {
            parsedUri.parcel = (String)tokenizer.nextElement();
            LogUtils.DEBUG("** parcelName = " + parsedUri.parcel);
        }
        if (parsedUri.function != null && parsedUri.function.length() > 0) {
            parsedUri.function = parsedUri.function.substring(parsedUri.parcel.length() + 1);
        }
        parsedUri.location = sfUri.getParameter("location");
        LogUtils.DEBUG("** location = " + parsedUri.location + "\nfunction = " + parsedUri.function + "\nparcel = " + parsedUri.parcel + "\nlocation = " + parsedUri.location);
        return parsedUri;
    }
}

