/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods.multipart;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringPart
extends PartBase {
    private static final Log LOG = LogFactory.getLog(StringPart.class);
    public static final String DEFAULT_CONTENT_TYPE = "text/plain";
    public static final String DEFAULT_CHARSET = "US-ASCII";
    public static final String DEFAULT_TRANSFER_ENCODING = "8bit";
    private byte[] content;
    private String value;

    public StringPart(String string, String string2, String string3) {
        super(string, DEFAULT_CONTENT_TYPE, string3 == null ? DEFAULT_CHARSET : string3, DEFAULT_TRANSFER_ENCODING);
        if (string2 == null) {
            throw new IllegalArgumentException("Value may not be null");
        }
        if (string2.indexOf(0) != -1) {
            throw new IllegalArgumentException("NULs may not be present in string parts");
        }
        this.value = string2;
    }

    public StringPart(String string, String string2) {
        this(string, string2, null);
    }

    private byte[] getContent() {
        if (this.content == null) {
            this.content = EncodingUtil.getBytes(this.value, this.getCharSet());
        }
        return this.content;
    }

    protected void sendData(OutputStream outputStream) throws IOException {
        LOG.trace((Object)"enter sendData(OutputStream)");
        outputStream.write(this.getContent());
    }

    protected long lengthOfData() throws IOException {
        LOG.trace((Object)"enter lengthOfData()");
        return this.getContent().length;
    }

    public void setCharSet(String string) {
        super.setCharSet(string);
        this.content = null;
    }
}

