/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.LivenessMemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.SampledMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.memory.DiffAllocResultsPanel;
import org.netbeans.lib.profiler.ui.memory.DiffLivenessResultsPanel;
import org.netbeans.lib.profiler.ui.memory.DiffSampledResultsPanel;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.MemoryResultsPanel;
import org.netbeans.lib.profiler.ui.memory.SnapshotLivenessResultsPanel;
import org.netbeans.lib.profiler.utils.VMUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.ResultsManager;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.openide.actions.FindAction;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public class MemoryDiffPanel
extends JPanel
implements SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private Component findActionPresenter;
    private Component findNextPresenter;
    private Component findPreviousPresenter;
    private MemoryResultsPanel memoryPanel;
    private Lookup.Provider project;

    public MemoryDiffPanel(Lookup lookup, MemoryResultsSnapshot memoryResultsSnapshot, LoadedSnapshot loadedSnapshot, LoadedSnapshot loadedSnapshot2, int n, boolean bl, Lookup.Provider provider) {
        String string;
        WeakReference[] weakReferenceArray;
        DiffSampledResultsPanel diffSampledResultsPanel;
        this.project = provider;
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        DiffActionsHandler diffActionsHandler = new DiffActionsHandler();
        if (memoryResultsSnapshot instanceof SampledMemoryResultsDiff) {
            this.memoryPanel = new DiffSampledResultsPanel((SampledMemoryResultsSnapshot)((SampledMemoryResultsDiff)memoryResultsSnapshot), (MemoryResUserActionsHandler)diffActionsHandler);
            diffSampledResultsPanel = (DiffSampledResultsPanel)this.memoryPanel;
            diffSampledResultsPanel.setSorting(n, bl);
            diffSampledResultsPanel.prepareResults();
        } else if (memoryResultsSnapshot instanceof AllocMemoryResultsDiff) {
            this.memoryPanel = new DiffAllocResultsPanel((AllocMemoryResultsSnapshot)((AllocMemoryResultsDiff)memoryResultsSnapshot), (MemoryResUserActionsHandler)diffActionsHandler);
            diffSampledResultsPanel = (DiffAllocResultsPanel)this.memoryPanel;
            diffSampledResultsPanel.setSorting(n, bl);
            diffSampledResultsPanel.prepareResults();
        } else if (memoryResultsSnapshot instanceof LivenessMemoryResultsDiff) {
            this.memoryPanel = new DiffLivenessResultsPanel((LivenessMemoryResultsSnapshot)((LivenessMemoryResultsDiff)memoryResultsSnapshot), (MemoryResUserActionsHandler)diffActionsHandler, 1);
            diffSampledResultsPanel = (SnapshotLivenessResultsPanel)this.memoryPanel;
            diffSampledResultsPanel.setSorting(n, bl);
            diffSampledResultsPanel.prepareResults();
        }
        this.add((Component)this.memoryPanel, "Center");
        diffSampledResultsPanel = ProfilerToolbar.create((boolean)true);
        diffSampledResultsPanel.add((Action)new ExportAction(this, null));
        diffSampledResultsPanel.add((Action)new SaveViewAction(this));
        diffSampledResultsPanel.addSeparator();
        ContextAwareAction contextAwareAction = (ContextAwareAction)SystemAction.get(FindAction.class);
        this.findActionPresenter = diffSampledResultsPanel.add(contextAwareAction.createContextAwareInstance(lookup));
        this.findPreviousPresenter = diffSampledResultsPanel.add((Action)new FindPreviousAction(this));
        this.findNextPresenter = diffSampledResultsPanel.add((Action)new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            weakReferenceArray = (WeakReference[])this.findActionPresenter;
            weakReferenceArray.setIcon(Icons.getIcon((String)"GeneralIcons.Find"));
            weakReferenceArray.setText("");
            weakReferenceArray.setToolTipText(Bundle.MemorySnapshotPanel_FindActionTooltip());
        }
        this.findActionPresenter.setEnabled(true);
        this.findPreviousPresenter.setEnabled(true);
        this.findNextPresenter.setEnabled(true);
        diffSampledResultsPanel.addFiller();
        weakReferenceArray = new WeakReference[2];
        final String string2 = loadedSnapshot.getFile() == null ? null : loadedSnapshot.getFile().getAbsolutePath();
        String string3 = string = loadedSnapshot2.getFile() == null ? null : loadedSnapshot2.getFile().getAbsolutePath();
        if (string2 == null) {
            weakReferenceArray[0] = new WeakReference<LoadedSnapshot>(loadedSnapshot);
        }
        if (string == null) {
            weakReferenceArray[1] = new WeakReference<LoadedSnapshot>(loadedSnapshot2);
        }
        final ResultsManager resultsManager = ResultsManager.getDefault();
        String string4 = "<a href='file:/1'>" + resultsManager.getSnapshotDisplayName(loadedSnapshot) + "</a>";
        String string5 = "<a href='file:/2'>" + resultsManager.getSnapshotDisplayName(loadedSnapshot2) + "</a>";
        HTMLLabel hTMLLabel = new HTMLLabel(Bundle.MemoryDiffPanel_SnapshotsComparisonString(string4, string5)){

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            protected void showURL(URL uRL) {
                Object object;
                LoadedSnapshot loadedSnapshot = null;
                if ("file:/1".equals(uRL.toString())) {
                    if (string2 != null) {
                        object = new File(string2);
                        if (((File)object).exists()) {
                            loadedSnapshot = resultsManager.loadSnapshot(FileUtil.toFileObject((File)object));
                        }
                    } else {
                        loadedSnapshot = (LoadedSnapshot)weakReferenceArray[0].get();
                    }
                } else if ("file:/2".equals(uRL.toString())) {
                    if (string != null) {
                        object = new File(string);
                        if (((File)object).exists()) {
                            loadedSnapshot = resultsManager.loadSnapshot(FileUtil.toFileObject((File)object));
                        }
                    } else {
                        loadedSnapshot = (LoadedSnapshot)weakReferenceArray[1].get();
                    }
                }
                if (loadedSnapshot != null) {
                    object = SnapshotResultsWindow.get(loadedSnapshot);
                    object.open();
                    object.requestActive();
                } else {
                    ProfilerDialogs.displayWarning((String)Bundle.MemoryDiffPanel_SnapshotNotAvailableMsg());
                }
            }
        };
        hTMLLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
        diffSampledResultsPanel.add((Component)hTMLLabel);
        this.add((Component)diffSampledResultsPanel.getComponent(), "North");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryDiffPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MemoryDiffPanel.this.performFindNext();
            }
        });
    }

    public String getTitle() {
        return Bundle.MemoryDiffPanel_PanelTitle();
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        return this.memoryPanel.getCurrentViewScreenshot(bl);
    }

    @Override
    public String getViewName() {
        return "memory_diff";
    }

    @Override
    public boolean fitsVisibleArea() {
        return this.memoryPanel.fitsVisibleArea();
    }

    @Override
    public boolean hasView() {
        return true;
    }

    @Override
    public void performFind() {
        String string = FindDialog.getFindString();
        if (string == null) {
            return;
        }
        this.memoryPanel.setFindString(string);
        if (!this.memoryPanel.findFirst()) {
            ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindNext() {
        if (!this.memoryPanel.isFindStringDefined()) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.memoryPanel.setFindString(string);
        }
        if (!this.memoryPanel.findNext()) {
            ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindPrevious() {
        if (!this.memoryPanel.isFindStringDefined()) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.memoryPanel.setFindString(string);
        }
        if (!this.memoryPanel.findPrevious()) {
            ProfilerDialogs.displayInfo((String)Bundle.MemorySnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void requestFocus() {
        this.memoryPanel.requestFocus();
    }

    @Override
    public void exportData(int n, ExportDataDumper exportDataDumper) {
        if (this.memoryPanel instanceof DiffSampledResultsPanel) {
            ((DiffSampledResultsPanel)this.memoryPanel).exportData(n, exportDataDumper, Bundle.MemoryDiffPanel_PanelTitle());
        } else if (this.memoryPanel instanceof DiffAllocResultsPanel) {
            ((DiffAllocResultsPanel)this.memoryPanel).exportData(n, exportDataDumper, Bundle.MemoryDiffPanel_PanelTitle());
        } else {
            ((DiffLivenessResultsPanel)this.memoryPanel).exportData(n, exportDataDumper, Bundle.MemoryDiffPanel_PanelTitle());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return false;
    }

    @Override
    public boolean hasExportableView() {
        return true;
    }

    private class DiffActionsHandler
    implements MemoryResUserActionsHandler {
        private DiffActionsHandler() {
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            if (string2 == null && string3 == null && (VMUtils.isVMPrimitiveType((String)string) || VMUtils.isPrimitiveType((String)string))) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_PRIMITIVE_SRC_MSG);
            } else if ("org.netbeans.lib.profiler.server.ProfilerRuntimeMemory".equals(string) && "traceVMObjectAlloc".equals(string2)) {
                ProfilerDialogs.displayWarning((String)CANNOT_SHOW_REFLECTION_SRC_MSG);
            } else {
                GoToSource.openSource((Lookup.Provider)MemoryDiffPanel.this.project, (String)string, (String)string2, (String)string3);
            }
        }

        public void showStacksForClass(int n, int n2, boolean bl) {
        }
    }
}

