/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.util.NbBundle;

final class Boolean3WayEditor
implements ExPropertyEditor,
InplaceEditor.Factory {
    Boolean v = null;
    private transient List<PropertyChangeListener> propertyChangeListenerList;
    private Boolean3Inplace renderer = null;

    @Override
    public String getAsText() {
        if (this.v == null) {
            return NbBundle.getMessage(Boolean3WayEditor.class, (String)"CTL_Different_Values");
        }
        if (Boolean.TRUE.equals(this.v)) {
            return Boolean.TRUE.toString();
        }
        return Boolean.FALSE.toString();
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public String getJavaInitializationString() {
        if (this.v == null) {
            return "null";
        }
        if (Boolean.TRUE.equals(this.v)) {
            return "Boolean.TRUE";
        }
        return "Boolean.FALSE";
    }

    @Override
    public String[] getTags() {
        return null;
    }

    @Override
    public Object getValue() {
        return this.v;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        if (this.renderer == null) {
            this.renderer = new Boolean3Inplace();
        }
        this.renderer.setSize(rectangle.width, rectangle.height);
        this.renderer.doLayout();
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        this.renderer.setOpaque(false);
        this.renderer.paint(graphics2);
        graphics2.dispose();
    }

    @Override
    public void setAsText(String string) {
        if (Boolean.TRUE.toString().compareToIgnoreCase(string) == 0) {
            this.setValue(Boolean.TRUE);
        } else {
            this.setValue(Boolean.FALSE);
        }
    }

    @Override
    public void setValue(Object object) {
        if (this.v != object) {
            this.v = (Boolean)object;
            this.firePropertyChange();
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void attachEnv(PropertyEnv propertyEnv) {
        propertyEnv.registerInplaceEditorFactory(this);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListenerList == null) {
            this.propertyChangeListenerList = new ArrayList<PropertyChangeListener>();
        }
        this.propertyChangeListenerList.add(propertyChangeListener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.propertyChangeListenerList != null) {
            this.propertyChangeListenerList.remove(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange() {
        List list;
        Object object = this;
        synchronized (object) {
            if (this.propertyChangeListenerList == null) {
                return;
            }
            list = (List)((ArrayList)this.propertyChangeListenerList).clone();
        }
        object = new PropertyChangeEvent(this, null, null, null);
        for (int i = 0; i < list.size(); ++i) {
            ((PropertyChangeListener)list.get(i)).propertyChange((PropertyChangeEvent)object);
        }
    }

    @Override
    public InplaceEditor getInplaceEditor() {
        return new Boolean3Inplace();
    }

    class Boolean3Inplace
    extends JCheckBox
    implements InplaceEditor {
        private PropertyModel propertyModel = null;
        private final int NOT_SELECTED = 0;
        private final int SELECTED = 1;
        private final int DONT_CARE = 2;
        private final ButtonModel3Way model3way;

        Boolean3Inplace() {
            if (!PropUtils.isAqua) {
                this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            }
            super.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    Boolean3Inplace.this.grabFocus();
                    Boolean3Inplace.this.model3way.nextState();
                }
            });
            ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
            actionMapUIResource.put("pressed", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Boolean3Inplace.this.grabFocus();
                    Boolean3Inplace.this.model3way.nextState();
                }
            });
            actionMapUIResource.put("released", null);
            SwingUtilities.replaceUIActionMap(this, actionMapUIResource);
            this.model3way = new ButtonModel3Way(this.getModel());
            this.setModel(this.model3way);
            this.setState(null == Boolean3WayEditor.this.v ? 2 : (Boolean3WayEditor.this.v != false ? 1 : 0));
        }

        @Override
        public void addMouseListener(MouseListener mouseListener) {
        }

        public void setState(int n) {
            this.model3way.setState(n);
        }

        public int getState() {
            return this.model3way.getState();
        }

        @Override
        public void setSelected(boolean bl) {
            if (bl) {
                this.setState(1);
            } else {
                this.setState(0);
            }
        }

        @Override
        public String getText() {
            return PropUtils.noCheckboxCaption ? "" : NbBundle.getMessage(Boolean3WayEditor.class, (String)"CTL_Different_Values");
        }

        @Override
        public void clear() {
            this.propertyModel = null;
        }

        @Override
        public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        }

        @Override
        public JComponent getComponent() {
            return this;
        }

        @Override
        public KeyStroke[] getKeyStrokes() {
            return null;
        }

        @Override
        public PropertyEditor getPropertyEditor() {
            return Boolean3WayEditor.this;
        }

        @Override
        public Object getValue() {
            return this.getState() == 2 ? null : (this.getState() == 1 ? Boolean.TRUE : Boolean.FALSE);
        }

        @Override
        public void reset() {
            this.setState(null == Boolean3WayEditor.this.v ? 2 : (Boolean3WayEditor.this.v != false ? 1 : 0));
        }

        @Override
        public void setValue(Object object) {
            this.setState(null == object ? 2 : ((Boolean)object != false ? 1 : 0));
        }

        @Override
        public boolean supportsTextEntry() {
            return false;
        }

        @Override
        public void setPropertyModel(PropertyModel propertyModel) {
            this.propertyModel = propertyModel;
        }

        @Override
        public PropertyModel getPropertyModel() {
            return this.propertyModel;
        }

        @Override
        public boolean isKnownComponent(Component component) {
            return false;
        }

        private class ButtonModel3Way
        implements ButtonModel {
            private final ButtonModel other;

            private ButtonModel3Way(ButtonModel buttonModel) {
                this.other = buttonModel;
            }

            private void setState(int n) {
                if (n == 0) {
                    this.other.setArmed(false);
                    this.setPressed(false);
                    this.setSelected(false);
                } else if (n == 1) {
                    this.other.setArmed(false);
                    this.setPressed(false);
                    this.setSelected(true);
                } else {
                    this.other.setArmed(true);
                    this.setPressed(true);
                    this.setSelected(true);
                }
            }

            private int getState() {
                if (this.isSelected() && !this.isArmed()) {
                    return 1;
                }
                if (this.isSelected() && this.isArmed()) {
                    return 2;
                }
                return 0;
            }

            private void nextState() {
                int n = this.getState();
                if (n == 0) {
                    this.setState(1);
                } else if (n == 1) {
                    this.setState(2);
                } else if (n == 2) {
                    this.setState(0);
                }
            }

            @Override
            public void setArmed(boolean bl) {
            }

            @Override
            public void setEnabled(boolean bl) {
                Boolean3Inplace.this.setFocusable(bl);
                this.other.setEnabled(bl);
            }

            @Override
            public boolean isArmed() {
                return this.other.isArmed();
            }

            @Override
            public boolean isSelected() {
                return this.other.isSelected();
            }

            @Override
            public boolean isEnabled() {
                return this.other.isEnabled();
            }

            @Override
            public boolean isPressed() {
                return this.other.isPressed();
            }

            @Override
            public boolean isRollover() {
                return this.other.isRollover();
            }

            @Override
            public void setSelected(boolean bl) {
                this.other.setSelected(bl);
            }

            @Override
            public void setPressed(boolean bl) {
                this.other.setPressed(bl);
            }

            @Override
            public void setRollover(boolean bl) {
                this.other.setRollover(bl);
            }

            @Override
            public void setMnemonic(int n) {
                this.other.setMnemonic(n);
            }

            @Override
            public int getMnemonic() {
                return this.other.getMnemonic();
            }

            @Override
            public void setActionCommand(String string) {
                this.other.setActionCommand(string);
            }

            @Override
            public String getActionCommand() {
                return this.other.getActionCommand();
            }

            @Override
            public void setGroup(ButtonGroup buttonGroup) {
                this.other.setGroup(buttonGroup);
            }

            @Override
            public void addActionListener(ActionListener actionListener) {
                this.other.addActionListener(actionListener);
            }

            @Override
            public void removeActionListener(ActionListener actionListener) {
                this.other.removeActionListener(actionListener);
            }

            @Override
            public void addItemListener(ItemListener itemListener) {
                this.other.addItemListener(itemListener);
            }

            @Override
            public void removeItemListener(ItemListener itemListener) {
                this.other.removeItemListener(itemListener);
            }

            @Override
            public void addChangeListener(ChangeListener changeListener) {
                this.other.addChangeListener(changeListener);
            }

            @Override
            public void removeChangeListener(ChangeListener changeListener) {
                this.other.removeChangeListener(changeListener);
            }

            @Override
            public Object[] getSelectedObjects() {
                return this.other.getSelectedObjects();
            }
        }
    }
}

