/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.MutableURLClassLoader;
import org.gradle.internal.classloader.TransformingClassLoader;
import org.gradle.tooling.internal.provider.PayloadClassLoaderFactory;
import org.gradle.tooling.provider.model.internal.LegacyConsumerInterface;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientSidePayloadClassLoaderFactory
implements PayloadClassLoaderFactory {
    private final PayloadClassLoaderFactory classLoaderFactory;

    public ClientSidePayloadClassLoaderFactory(PayloadClassLoaderFactory classLoaderFactory) {
        this.classLoaderFactory = classLoaderFactory;
    }

    @Override
    public ClassLoader getClassLoaderFor(ClassLoaderSpec spec, List<? extends ClassLoader> parents) {
        if (spec instanceof MutableURLClassLoader.Spec) {
            MutableURLClassLoader.Spec clSpec = (MutableURLClassLoader.Spec)spec;
            if (parents.size() != 1) {
                throw new IllegalStateException("Expected exactly one parent ClassLoader");
            }
            return new MixInClassLoader(parents.get(0), clSpec.getClasspath());
        }
        return this.classLoaderFactory.getClassLoaderFor(spec, parents);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MixInClassLoader
    extends TransformingClassLoader {
        public MixInClassLoader(ClassLoader parent, List<URL> classPath) {
            super(parent, classPath);
        }

        @Override
        protected byte[] transform(byte[] bytes) {
            ClassReader classReader = new ClassReader(bytes);
            AnnotationDetector detector = new AnnotationDetector();
            classReader.accept((ClassVisitor)detector, 3);
            if (!detector.found) {
                return bytes;
            }
            if (this.findLoadedClass(detector.interfaceName) == null) {
                ClassWriter emptyWriter = new ClassWriter(0);
                emptyWriter.visit(49, 513, detector.interfaceName.replace('.', '/'), null, Type.getType(Object.class).getInternalName(), null);
                emptyWriter.visitEnd();
                byte[] emptyBytecode = emptyWriter.toByteArray();
                this.defineClass(detector.interfaceName, emptyBytecode, 0, emptyBytecode.length);
            }
            ClassWriter classWriter = new ClassWriter(0);
            classReader.accept((ClassVisitor)new TransformingAdapter(classWriter, detector.interfaceName), 0);
            bytes = classWriter.toByteArray();
            return bytes;
        }

        private static class TransformingAdapter
        extends ClassVisitor {
            private final String mixInInterface;

            public TransformingAdapter(ClassWriter classWriter, String mixInInterface) {
                super(327680, (ClassVisitor)classWriter);
                this.mixInInterface = mixInInterface;
            }

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                LinkedHashSet<String> allInterfaces = new LinkedHashSet<String>(Arrays.asList(interfaces));
                allInterfaces.add(this.mixInInterface.replace('.', '/'));
                super.visit(version, access, name, signature, superName, allInterfaces.toArray(new String[0]));
            }
        }

        private static class AnnotationDetector
        extends ClassVisitor {
            private static final String ANNOTATION_DESCRIPTOR = Type.getType(LegacyConsumerInterface.class).getDescriptor();
            String interfaceName;
            private boolean found;

            private AnnotationDetector() {
                super(327680);
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if (desc.equals(ANNOTATION_DESCRIPTOR)) {
                    this.found = true;
                }
                return new AnnotationVisitor(327680){

                    public void visit(String name, Object value) {
                        if (name.equals("value")) {
                            AnnotationDetector.this.interfaceName = value.toString();
                        }
                    }
                };
            }
        }
    }
}

