/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.downloadtasks;

import java.awt.Component;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractChangesetDownloadTask;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.data.osm.ChangesetDataSet;
import org.openstreetmap.josm.gui.ExceptionDialogUtil;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.I18n;
import org.xml.sax.SAXException;

public class ChangesetContentDownloadTask
extends AbstractChangesetDownloadTask {
    public ChangesetContentDownloadTask(int n) {
        this(Main.parent, n);
    }

    public ChangesetContentDownloadTask(Collection<Integer> collection) {
        this(Main.parent, collection);
    }

    public ChangesetContentDownloadTask(Component component, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(MessageFormat.format("Expected integer value > 0 for parameter ''{0}'', got ''{1}''", "changesetId", n));
        }
        this.setDownloadTask(new DownloadTask(component, Collections.singleton(n)));
    }

    public ChangesetContentDownloadTask(Component component, Collection<Integer> collection) {
        this.setDownloadTask(new DownloadTask(component, collection));
    }

    protected static boolean isAvailableLocally(int n) {
        return ChangesetCache.getInstance().get(n) != null;
    }

    class DownloadTask
    extends AbstractChangesetDownloadTask.RunnableDownloadTask {
        private final List<Integer> toDownload;

        DownloadTask(Component component, Collection<Integer> collection) {
            super(component, I18n.tr("Downloading changeset content", new Object[0]));
            this.toDownload = new ArrayList<Integer>();
            for (Integer n : collection != null ? collection : Collections.emptyList()) {
                if (n == null || n <= 0) continue;
                this.toDownload.add(n);
            }
        }

        protected void downloadChangeset(int n) throws OsmTransferException {
            Changeset changeset = this.reader.readChangeset(n, false, this.getProgressMonitor().createSubTaskMonitor(0, false));
            ChangesetCache.getInstance().update(changeset);
        }

        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            try {
                this.getProgressMonitor().setTicksCount(this.toDownload.size());
                int n = 0;
                for (int n2 : this.toDownload) {
                    ++n;
                    if (!ChangesetContentDownloadTask.isAvailableLocally(n2)) {
                        this.getProgressMonitor().setCustomText(I18n.tr("({0}/{1}) Downloading changeset {2}...", n, this.toDownload.size(), n2));
                        this.downloadChangeset(n2);
                    }
                    if (ChangesetContentDownloadTask.this.isCanceled()) {
                        return;
                    }
                    this.getProgressMonitor().setCustomText(I18n.tr("({0}/{1}) Downloading content for changeset {2}...", n, this.toDownload.size(), n2));
                    ChangesetDataSet changesetDataSet = this.reader.downloadChangeset(n2, this.getProgressMonitor().createSubTaskMonitor(0, false));
                    Changeset changeset = ChangesetCache.getInstance().get(n2);
                    changeset.setContent(changesetDataSet);
                    ChangesetCache.getInstance().update(changeset);
                    this.downloadedChangesets.add(changeset);
                    this.getProgressMonitor().worked(1);
                }
            }
            catch (OsmTransferCanceledException osmTransferCanceledException) {
                ChangesetContentDownloadTask.this.setCanceled(true);
                return;
            }
            catch (OsmTransferException osmTransferException) {
                if (ChangesetContentDownloadTask.this.isCanceled()) {
                    return;
                }
                this.rememberLastException(osmTransferException);
            }
        }

        @Override
        protected void finish() {
            ChangesetContentDownloadTask.this.rememberDownloadedData(this.downloadedChangesets);
            if (ChangesetContentDownloadTask.this.isCanceled()) {
                return;
            }
            if (this.lastException != null) {
                ExceptionDialogUtil.explainException(this.lastException);
            }
        }
    }
}

