/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.SubPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class PreferenceDialog
extends JDialog {
    private final PreferenceTabbedPane tpPreferences = new PreferenceTabbedPane();
    private boolean canceled;

    public PreferenceDialog(Component component) {
        super((Window)GuiHelper.getFrameForComponent(component), I18n.tr("Preferences", new Object[0]), Dialog.ModalityType.DOCUMENT_MODAL);
        this.build();
        this.setMinimumSize(new Dimension(600, 350));
        this.setMaximumSize(GuiHelper.getScreenSize());
    }

    protected JPanel buildActionPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Expert mode", new Object[0]));
        jCheckBox.setSelected(ExpertToggleAction.isExpert());
        jCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExpertToggleAction.getInstance().actionPerformed(null);
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add(new SideButton(new OKAction()));
        jPanel2.add(new SideButton(new CancelAction()));
        jPanel2.add(new SideButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/Preferences"))));
        jPanel.add((Component)jCheckBox, GBC.std().insets(5, 0, 0, 0));
        jPanel.add((Component)jPanel2, GBC.std().fill(2));
        return jPanel;
    }

    protected final void build() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.tpPreferences, "Center");
        this.tpPreferences.buildGui();
        this.tpPreferences.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        container.add((Component)this.buildActionPanel(), "South");
        this.addWindowListener(new WindowEventHandler());
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.getRootPane().getActionMap().put("cancel", new CancelAction());
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/Preferences"));
    }

    public PreferenceTabbedPane getTabbedPane() {
        return this.tpPreferences;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            Insets insets = this.getParent().getInsets();
            Dimension dimension = this.getParent().getSize();
            dimension = new Dimension(Math.min(dimension.width - insets.left - insets.right, 700), Math.min(dimension.height - insets.top - insets.bottom, 800));
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), dimension)).applySafe(this);
        } else if (this.isShowing()) {
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public void selectPreferencesTabByName(String string) {
        this.tpPreferences.selectTabByName(string);
    }

    public void selectPreferencesTabByClass(Class<? extends TabPreferenceSetting> clazz) {
        this.tpPreferences.selectTabByPref(clazz);
    }

    public void selectSubPreferencesTabByClass(Class<? extends SubPreferenceSetting> clazz) {
        this.tpPreferences.selectSubTabByPref(clazz);
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            new CancelAction().cancel();
        }
    }

    class OKAction
    extends AbstractAction {
        OKAction() {
            this.putValue("Name", I18n.tr("OK", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
            this.putValue("ShortDescription", I18n.tr("Save the preferences and close the dialog", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            for (PreferenceTabbedPane.ValidationListener validationListener : ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners) {
                if (validationListener.validatePreferences()) continue;
                return;
            }
            PreferenceDialog.this.tpPreferences.savePreferences();
            ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners.clear();
            PreferenceDialog.this.setCanceled(false);
            PreferenceDialog.this.setVisible(false);
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Cancel", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the preferences dialog and discard preference updates", new Object[0]));
        }

        public void cancel() {
            PreferenceDialog.this.setCanceled(true);
            PreferenceDialog.this.setVisible(false);
            ((PreferenceDialog)PreferenceDialog.this).tpPreferences.validationListeners.clear();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancel();
        }
    }
}

