/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.GroupFigure;
import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.Undoable;
import CH.ifa.draw.util.UndoableAdapter;
import java.util.Vector;

public class GroupCommand
extends AbstractCommand {
    public GroupCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selectionElements());
        ((UndoActivity)this.getUndoActivity()).groupFigures();
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 1;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends UndoableAdapter {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
            this.setUndoable(true);
            this.setRedoable(true);
        }

        public boolean undo() {
            if (!super.undo()) {
                return false;
            }
            this.getDrawingView().clearSelection();
            this.getDrawingView().drawing().orphanAll(this.getAffectedFigures());
            Vector<Figure> affectedFigures = new Vector<Figure>();
            FigureEnumeration fe = this.getAffectedFigures();
            while (fe.hasMoreElements()) {
                Figure currentFigure = fe.nextFigure();
                this.getDrawingView().drawing().addAll(currentFigure.figures());
                this.getDrawingView().addToSelectionAll(currentFigure.figures());
                FigureEnumeration groupedFigures = currentFigure.figures();
                while (groupedFigures.hasMoreElements()) {
                    affectedFigures.addElement(groupedFigures.nextFigure());
                }
            }
            this.setAffectedFigures(new FigureEnumerator(affectedFigures));
            return true;
        }

        public boolean redo() {
            if (this.isRedoable()) {
                this.groupFigures();
                return true;
            }
            return false;
        }

        public void groupFigures() {
            this.getDrawingView().drawing().orphanAll(this.getAffectedFigures());
            this.getDrawingView().clearSelection();
            GroupFigure group = new GroupFigure();
            group.addAll(this.getAffectedFigures());
            Figure figure = this.getDrawingView().drawing().add(group);
            this.getDrawingView().addToSelection(figure);
            Vector<Figure> affectedFigures = new Vector<Figure>();
            affectedFigures.addElement(figure);
            this.setAffectedFigures(new FigureEnumerator(affectedFigures));
        }
    }
}

