/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Source;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.spider.parser.SpiderParser;

public class SpiderTextParser
extends SpiderParser {
    private static final Pattern patternURL = Pattern.compile("\\W(http(s?)://[^\\x00-\\x1f\"'\\s<>#]+)");

    @Override
    public boolean parseResource(HttpMessage httpMessage, Source source, int n) {
        log.debug((Object)"Parsing a non-HTML text resource.");
        Matcher matcher = patternURL.matcher(httpMessage.getResponseBody().toString());
        while (matcher.find()) {
            String string = matcher.group(1);
            this.processURL(httpMessage, n, string, "");
        }
        return false;
    }

    @Override
    public boolean canParseResource(HttpMessage httpMessage, String string, boolean bl) {
        return !bl && httpMessage.getResponseHeader().isText() && !httpMessage.getResponseHeader().isHtml();
    }
}

